 /*
  * Khoros: $Id: gw_util.c,v 1.1 1991/05/10 15:59:30 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: gw_util.c,v 1.1 1991/05/10 15:59:30 khoros Exp $";
#endif

 /*
  * $Log: gw_util.c,v $
 * Revision 1.1  1991/05/10  15:59:30  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "writer.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>                Ghostwriter Utility Routines           <<<<
   >>>>                                                       <<<<
   >>>>                ascii_name()                           <<<<
   >>>>                ascii_def_value()                      <<<<
   >>>>                ascii_def_toggle_value()               <<<<
   >>>>                gw_print_bounds_float()   	      <<<<
   >>>>                gw_print_bounds_int()   	      	      <<<<
   >>>>                gw_print_toggle_vals()		      <<<<
   >>>>                gw_print_syntax()		      <<<<
   >>>>                                                       <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */




/************************************************************
*
*  Routine Name: ascii_name
*
*      Purpose:  This routine returns the ascii name of the type of argument
*
*        Input:  typeflag - typeflag of the database line
*
*       Output:  the string name of that type
*
*    Called by:  print_opt_args()
*
*   Written By:  Danielle Argiro
*
*************************************************************/

char *ascii_name(typeflag)
int typeflag;
{
    switch (typeflag){
		
	case InputFile:
	     return("infile");
	     break;

	case OutputFile:
	     return("outfile");
	     break;

	case IntegerOpt:
	     return("integer");
	     break;

	case FloatOpt:
	     return("float");
	     break;

	case StringOpt:
	     return("string");
	     break;

	case LogicOpt:
	     return("boolean");
	     break;

	default:
	     return(NULL);
	}
}



/************************************************************
*
*  Routine Name: ascii_def_val
*
*      Purpose:  This routine returns the ascii rep of the default
*		 value of the argument, depending on type of argument
*
*        Input:  line_info - lineinfo structure from the database line
*
*       Output:  the string rep of the default for that line
*
*    Called by:  print_opt_args()
*
*   Written By:  Danielle Argiro
*
*************************************************************/

char *ascii_def_val(line_info)
Line_Info *line_info;
{
    char temp[MaxLength];
    char *def_str;

    switch (line_info->typeflag) {
		
	case InputFile:
	case OutputFile:
	     if (line_info->file_def == NULL)
	         def_str = xvf_strcpy("null");
	     else def_str = xvf_strcpy(line_info->file_def);
	     break;

	case IntegerOpt:
	     sprintf(temp, "%d", line_info->int_def);
	     def_str = xvf_strcpy(temp);
	     break;

	case FloatOpt:
	     sprintf(temp, "%g", line_info->float_def);
	     def_str = xvf_strcpy(temp);
	     break;

	case StringOpt:
	     if (line_info->string_def == NULL)
	         def_str = xvf_strcpy("null");
	     else def_str = xvf_strcpy(line_info->string_def);
	     break;

	case LogicOpt:
	     if (line_info->logical_def == true)
	         def_str = xvf_strcpy("true");
	     else def_str = xvf_strcpy("false");
	     break;

	default:
	     def_str = NULL;
    }
    return(def_str);
}


/************************************************************
*
*  Routine Name: ascii_def_toggle_value
*
*      Purpose:  This routine returns the ascii rep of the default
*		 value of the toggle, depending on the type of toggle
*
*        Input:  line_info - lineinfo structure from the database line
*
*       Output:  the string rep of the default for that line
*
*    Called by:  print_opt_args()
*
*   Written By:  Danielle Argiro
*
*************************************************************/

char *ascii_def_toggle_value(toggle_ptr)
gw_toggle_struct *toggle_ptr;
{
    char temp[MaxLength]; char *def_val;

    if (toggle_ptr->type == LogicOpt) 
       sprintf(temp, "%d", toggle_ptr->def);
    else if (toggle_ptr->type == IntegerOpt) 
       sprintf(temp, "%d", toggle_ptr->intvals[toggle_ptr->def-1]);
    else if (toggle_ptr->type == FloatOpt) 
       sprintf(temp, "%g", toggle_ptr->floatvals[toggle_ptr->def-1]);
    else if (toggle_ptr->type == StringOpt) 
       sprintf(temp, "%s", toggle_ptr->stringvals[toggle_ptr->def-1]);

    def_val = xvf_strcpy(temp);
    return(def_val);
}



/************************************************************
*
*  Routine Name: gw_print_bounds_float
*
*      Purpose:  This routine prints the bounds of a float argument
*
*        Input:  file       - open stream to output file
*		 line_info  - lineinfo structure from the database line
*		 use_flag   - indicates to gw_print_syntax the identity of
*			     the calling routine, so that differently formatted
*			     output may be generated by this routine.
*
*       Output:  the bounds of the float argument are printed to file
*
*    Called by:  gw_print_opt_args()
*
*   Written By:  Danielle Argiro
*
*************************************************************/

gw_print_bounds_float(file, line_info, use_flag)
FILE	  *file;
Line_Info *line_info;
int	   use_flag;
{
    if (line_info->lower_float == line_info->upper_float)
    {
	if (line_info->lower_float == -2.0)
	{
	    if (use_flag == Man1Usage)
                fprintf(file, "bounds: value < 0.0\n.br\n");
	    else if (use_flag == MainHeader) 
                fprintf(file, "  (value < 0.0)");
	    else if (use_flag == VGCUsage)
                fprintf(file, ", < 0.0");
	}
	else if (line_info->lower_float == -1.0)
	{
	    if (use_flag == Man1Usage)
                fprintf(file, "bounds: value <= 0.0\n.br\n");
	    else if (use_flag == MainHeader) 
                fprintf(file, "  (value <= 0.0)");
	    else if (use_flag == VGCUsage)
                fprintf(file, ", <= 0.0");
	}
	else if (line_info->lower_float == 1.0)
	{
	    if (use_flag == Man1Usage)
                fprintf(file, "bounds: value >= 0.0\n.br\n");
	    else if (use_flag == MainHeader) 
                fprintf(file, "  (value >= 0.0)");
	    else if (use_flag == VGCUsage)
                fprintf(file, ", >= 0.0");
	}
	else if (line_info->lower_float == 2.0)
	{
	    if (use_flag == Man1Usage)
                fprintf(file, "bounds: value > 0.0\n.br\n");
	    else if (use_flag == MainHeader) 
                fprintf(file, "  (value > 0.0)");
	    else if (use_flag == VGCUsage)
                fprintf(file, ", > 0.0");
	}
        else
	{
	    if (use_flag == Man1Usage)
                fprintf(file, "bounds: no range checking\n.br\n");
	    else if (use_flag == MainHeader) 
                fprintf(file, " ");
	}
    }
    else   
    {
	 if (use_flag == Man1Usage)
             fprintf(file, "bounds: %f < [-%s] < %f\n.br\n", 
	 	     line_info->lower_float, line_info->variable, 
		     line_info->upper_float);
	 else if (use_flag == MainHeader) 
             fprintf(file, "  (%.3f < value < %.3f)", 
	 	     line_info->lower_float, line_info->upper_float);
	 else if (use_flag == VGCUsage)
             fprintf(file, ",  %.3f to %.3f", 
		     line_info->lower_float, line_info->upper_float);
    }
}



/************************************************************
*
*  Routine Name: gw_print_bounds_int
*
*      Purpose:  This routine prints the bounds of an integer argument
*
*        Input:  file - open stream to output file
*		 line_info - lineinfo structure from the database line
*		 use_flag   - indicates to gw_print_syntax the identity of
*			    the calling routine, so that differently formatted
*			    output may be generated by this routine.
*
*       Output:  the bounds of the float argument are printed to file
*
*    Called by:  gw_print_opt_args()
*
*   Written By:  Danielle Argiro
*
*************************************************************/

gw_print_bounds_int(file, line_info, use_flag)
FILE	  *file;
Line_Info *line_info;
int	   use_flag;
{
    if (line_info->lower_int == line_info->upper_int)
    {
	if (line_info->lower_int == -2.0)
	{
	    if (use_flag == Man1Usage)
                fprintf(file, "bounds: value < 0\n.br\n");
	    else if (use_flag == MainHeader) 
                fprintf(file, "  (value < 0)");
	    else if (use_flag == VGCUsage)
                fprintf(file, ", < 0");
	}
	else if (line_info->lower_int == -1.0)
	{
	    if (use_flag == Man1Usage)
                fprintf(file, "bounds: value <= 0\n.br\n");
	    else if (use_flag == MainHeader) 
                fprintf(file, "  (value <= 0)");
	    else if (use_flag == VGCUsage)
                fprintf(file, ", <= 0");
	}
	else if (line_info->lower_int == 1.0)
	{
	    if (use_flag == Man1Usage)
                fprintf(file, "bounds: value >= 0\n.br\n");
	    else if (use_flag == MainHeader) 
                fprintf(file, "  (value >= 0)");
	    else if (use_flag == VGCUsage)
                fprintf(file, ", >= 0");
	}
	else if (line_info->lower_int == 2.0)
	{
	    if (use_flag == Man1Usage)
                fprintf(file, "bounds: value > 0\n.br\n");
	    else if (use_flag == MainHeader) 
                fprintf(file, "  (value > 0)");
	    else if (use_flag == VGCUsage)
                fprintf(file, ", > 0");
	}
        else
	{
	    if (use_flag == Man1Usage)
                fprintf(file, "bounds: no range checking\n.br\n");
	    else if (use_flag == MainHeader) 
                fprintf(file, " ");
	}
    }
    else   
    {
	 if (use_flag == Man1Usage)
             fprintf(file, "bounds: %d < [-%s] < %d\n.br\n", 
		     line_info->lower_int, line_info->variable, 
		     line_info->upper_int);
	 else if (use_flag == MainHeader) 
             fprintf(file, "  (%d < value < %d)", 
	 	     line_info->lower_int, line_info->upper_int);
	 else if (use_flag == VGCUsage)
             fprintf(file, ", %d to %d", 
		     line_info->lower_int, line_info->upper_int);
    }
}


/************************************************************
*
*  Routine Name: gw_print_toggle_vals
*
*      Purpose:  This routine prints the possible toggle vals to the man1 file 
*
*        Input:  file       - open stream to man1 page
*		 toggle_ptr - pointer to the toggle structure
*		 use_flag   - indicates to gw_print_syntax the identity of
*			    the calling routine, so that differently formatted
*			    output may be generated by this routine.
*
*	Output:  prints the accepted toggle values to the man1 file
*
*    Called by:  gw_print_opt_args()
*                gw_print_req_args()
*
*   Written By:  Danielle Argiro
*
*************************************************************/

gw_print_toggle_vals(file, toggle_ptr, use_flag)

FILE *file;
gw_toggle_struct *toggle_ptr;
int   use_flag;
{
    int i;

    if (toggle_ptr->type == IntegerOpt) 
    {
        i = 0;
        while (i < toggle_ptr->elem_num)
	{
	    if (i < toggle_ptr->elem_num - 1)
	    {
	        if (use_flag == MainHeader)
		    fprintf(file, "%d (%s),\n *\t\t", 
				toggle_ptr->intvals[i], 
				toggle_ptr->elemdesc[i]);

		else if (use_flag == Man1Usage)
		    fprintf(file, "%d (%s), \n.br\n", 
				toggle_ptr->intvals[i], 
				toggle_ptr->elemdesc[i]);

	        else if (use_flag == VGCUsage)
		    fprintf(file, "\tfprintf(stderr, \"\\t\\t%d  (%s),\\n\");\n", 
			    toggle_ptr->intvals[i], toggle_ptr->elemdesc[i]);

	        else if (use_flag == VGCGetArgs)
		    fprintf(file, "\t\t   (stderr, \"%d\\n\\t\\t(%s), \");\n", 
			    toggle_ptr->intvals[i], toggle_ptr->elemdesc[i]);

		else if (use_flag == VGCpstrs)
		    fprintf(file, "\\t\\t%d (%s)\\n", 
			    toggle_ptr->intvals[i], toggle_ptr->elemdesc[i]);

	    }
	    else 
	    {
	        if (use_flag == MainHeader)
		    fprintf(file, "or %d (%s)\n *\t\t ", 
			toggle_ptr->intvals[i], toggle_ptr->elemdesc[i]);

		else if (use_flag == Man1Usage)
		    fprintf(file, "or %d (%s)\n.br\n", 
			toggle_ptr->intvals[i], toggle_ptr->elemdesc[i]);

	        else if (use_flag == VGCUsage)
		    fprintf(file, "\tfprintf(stderr, \"\\t\\tor %d  (%s)\\n\");\n", 
			    toggle_ptr->intvals[i], toggle_ptr->elemdesc[i]);

	        else if (use_flag == VGCGetArgs)
		    fprintf(file, "\t\t    fprintf(stderr, \"or %d (%s)\");\n", 
			    toggle_ptr->intvals[i], toggle_ptr->elemdesc[i]);

		else if (use_flag == VGCpstrs)
		    fprintf(file, "\\t\\tor %d (%s)\\n", 
			    toggle_ptr->intvals[i], toggle_ptr->elemdesc[i]);

	    }
	    i++;
	}
    }
    else if (toggle_ptr->type == LogicOpt)
    {
        i = 0;
        while (i < toggle_ptr->elem_num)
        {
            if (i < toggle_ptr->elem_num - 1)
	    {
	        if (use_flag == MainHeader)
                   fprintf(file, "%d (%s),\n *\t\t", 
			       toggle_ptr->logicvals[i],
			       toggle_ptr->elemdesc[i]);

		else if (use_flag == Man1Usage)
		    fprintf(file, "%d (%s), \n.br\n",
                                toggle_ptr->logicvals[i],
                                toggle_ptr->elemdesc[i]);

	        else if (use_flag == VGCUsage)
		    fprintf(file, "\tfprintf(stderr, \"\\t\\t%d  (%s),\\n\");\n",
                            toggle_ptr->logicvals[i], toggle_ptr->elemdesc[i]);

	        else if (use_flag == VGCGetArgs)
		    fprintf(file, "\t\t   (stderr, \"%d\\n\\t\\t(%s), \");\n",
                            toggle_ptr->logicvals[i], toggle_ptr->elemdesc[i]);
		
		else if (use_flag == VGCpstrs)
                    fprintf(file, "\\t\\t%d (%s)\\n",
                            toggle_ptr->logicvals[i], toggle_ptr->elemdesc[i]);
	    }
            else
	    {
		if (use_flag == MainHeader)
                    fprintf(file, "or %d (%s)\n *\t\t ",
                        toggle_ptr->logicvals[i], toggle_ptr->elemdesc[i]);

                else if (use_flag == Man1Usage)
                    fprintf(file, "or %d (%s)\n.br\n",
                        toggle_ptr->logicvals[i], toggle_ptr->elemdesc[i]);

                else if (use_flag == VGCUsage)
                    fprintf(file, "\tfprintf(stderr, \"\\t\\tor %d  (%s)\\n\");\n",
                            toggle_ptr->logicvals[i], toggle_ptr->elemdesc[i]);

                else if (use_flag == VGCGetArgs)
                    fprintf(file, "\t\t    fprintf(stderr, \"or %d (%s)\");\n",
                            toggle_ptr->logicvals[i], toggle_ptr->elemdesc[i]);

                else if (use_flag == VGCpstrs)
                    fprintf(file, "\\t\\tor %d (%s)\\n",
                            toggle_ptr->logicvals[i], toggle_ptr->elemdesc[i]);
	    }
            i++;
        }
    }
    else if (toggle_ptr->type == FloatOpt)
    {
        i = 0;
        while (i < toggle_ptr->elem_num)
        {
            if (i < toggle_ptr->elem_num - 1)
	    {
	        if (use_flag == MainHeader)
                   fprintf(file, "%g (%s),\n *\t\t", 
			       toggle_ptr->floatvals[i],
			       toggle_ptr->elemdesc[i]);

		else if (use_flag == Man1Usage)
		    fprintf(file, "%g (%s), \n.br\n",
                                toggle_ptr->floatvals[i],
                                toggle_ptr->elemdesc[i]);

	        else if (use_flag == VGCUsage)
		    fprintf(file, "\tfprintf(stderr, \"\\t\\t%g  (%s),\\n\");\n",
                            toggle_ptr->floatvals[i], toggle_ptr->elemdesc[i]);

	        else if (use_flag == VGCGetArgs)
		    fprintf(file, "\t\t   (stderr, \"%g\\n\\t\\t(%s), \");\n",
                            toggle_ptr->floatvals[i], toggle_ptr->elemdesc[i]);
		
		else if (use_flag == VGCpstrs)
                    fprintf(file, "\\t\\t%g (%s)\\n",
                            toggle_ptr->floatvals[i], toggle_ptr->elemdesc[i]);
	    }
            else
	    {
		if (use_flag == MainHeader)
                    fprintf(file, "or %g (%s)\n *\t\t ",
                        toggle_ptr->floatvals[i], toggle_ptr->elemdesc[i]);

                else if (use_flag == Man1Usage)
                    fprintf(file, "or %g (%s)\n.br\n",
                        toggle_ptr->floatvals[i], toggle_ptr->elemdesc[i]);

                else if (use_flag == VGCUsage)
                    fprintf(file, "\tfprintf(stderr, \"\\t\\tor %g  (%s)\\n\");\n",
                            toggle_ptr->floatvals[i], toggle_ptr->elemdesc[i]);

                else if (use_flag == VGCGetArgs)
                    fprintf(file, "\t\t    fprintf(stderr, \"or %g (%s)\");\n",
                            toggle_ptr->floatvals[i], toggle_ptr->elemdesc[i]);

                else if (use_flag == VGCpstrs)
                    fprintf(file, "\\t\\tor %g (%s)\\n",
                            toggle_ptr->floatvals[i], toggle_ptr->elemdesc[i]);
	    }
            i++;
        }
    }
    else if (toggle_ptr->type == StringOpt)
    {
        i = 0;
        while (i < toggle_ptr->elem_num)
        {
            if (i < toggle_ptr->elem_num - 1)
	    {
	        if (use_flag == MainHeader)
                   fprintf(file, "'%s' (%s),\n *\t\t", 
			       toggle_ptr->stringvals[i],
			       toggle_ptr->elemdesc[i]);

		else if (use_flag == Man1Usage)
		    fprintf(file, " '%s' (%s), \n.br\n",
                                toggle_ptr->stringvals[i],
                                toggle_ptr->elemdesc[i]);

	        else if (use_flag == VGCUsage)
		    fprintf(file, "\tfprintf(stderr, \"\\t\\t'%s'  (%s),\\n\");\n",
                            toggle_ptr->stringvals[i], toggle_ptr->elemdesc[i]);

	        else if (use_flag == VGCGetArgs)
		    fprintf(file, "\t\t   (stderr, \"'%s'\\n\\t\\t(%s), \");\n",
                            toggle_ptr->stringvals[i], toggle_ptr->elemdesc[i]);
		
		else if (use_flag == VGCpstrs)
                    fprintf(file, "\\t\\t'%s' (%s)\\n",
                            toggle_ptr->stringvals[i], toggle_ptr->elemdesc[i]);
	    }
            else
	    {
		if (use_flag == MainHeader)
                    fprintf(file, " or '%s' (%s)\n *\t\t ",
                        toggle_ptr->stringvals[i], toggle_ptr->elemdesc[i]);

                else if (use_flag == Man1Usage)
                    fprintf(file, "  or '%s' (%s)\n.br\n",
                        toggle_ptr->stringvals[i], toggle_ptr->elemdesc[i]);

                else if (use_flag == VGCUsage)
                    fprintf(file, "\tfprintf(stderr, \"\\t\\t or '%s'  (%s)\\n\");\n",
                            toggle_ptr->stringvals[i], toggle_ptr->elemdesc[i]);

                else if (use_flag == VGCGetArgs)
                    fprintf(file, "\t\t    fprintf(stderr, \" or '%s' (%s)\");\n",
                            toggle_ptr->stringvals[i], toggle_ptr->elemdesc[i]);

                else if (use_flag == VGCpstrs)
                    fprintf(file, "\\t\\tor '%s' (%s)\\n",
                            toggle_ptr->stringvals[i], toggle_ptr->elemdesc[i]);
	    }
            i++;
        }
    }
    else
    {
	fprintf(stderr, "gw_print_toggle_vals:\n");
	fprintf(stderr, "Error: unknown toggle type\n");
    }
}

/************************************************************
*
*  Routine Name: gw_print_syntax
*
*      Purpose:  This routine prints the syntax of the program one of:
*		 man1 file, header of main program, or to the generated
*		 gw_usage routine, depending on the alue of use_flag
*
*        Input:  file     - open stream to man1 page
*		 database - pointer to the internal database struct
*		 name     - name of the program being generated
*		 use_flag - indicates to gw_print_syntax the identity of
*			    the calling routine, so that differently formatted
*			    output may be generated by this routine.
*
*	Output:  prints the required arguments to the man1 file
*
*    Called by:  ghost_man1()
*
*   Written By:  Danielle Argiro
*
*************************************************************/

gw_print_syntax(file, database, name, use_flag)
FILE *file;
char **database;
char *name;
int  use_flag;
{
    int i, space_num;
    int index = 0, mut_excl_count = 0, toggle_count = 0;
    Line_Info line_info;
    mut_excl_link *mut_excl_ptr;
    gw_toggle_struct *toggle_ptr;
    char *whitespace;
    char *desc;

    space_num = xvf_strlen(name) + 2;
    xvf_clear_line_info(&line_info);

    if (use_flag == Man1Usage)
       fprintf(file, "%s\n", name);

    i = 0;
    whitespace = (char *) calloc (1, (space_num+2)*sizeof(char));
    while (i < space_num)
    {
	whitespace[i] = ' ';  i++;
    }
    whitespace[i] = '\0';
    
    /* 
     * print out required arguments 
     */
    while (index < gw_num_req)
    {
        xvf_gen_parse(database[gw_req_args[index]], &line_info);
	if (line_info.description != NULL)
	   desc = xvf_strcpy(line_info.description);
	else
	   desc = xvf_strcpy(" ");
	if (use_flag == Man1Usage)
               fprintf(file, ".IP -%s 15\n%s\n", line_info.variable, desc);
	else if (use_flag == MainHeader)
	{
            fprintf(file, " *%s-%s  %s ", whitespace,
		       line_info.variable, desc);
	    if (line_info.typeflag == FloatOpt)
		  gw_print_bounds_float(file, &line_info, MainHeader);
	    else if (line_info.typeflag == IntegerOpt)
		  gw_print_bounds_int(file, &line_info, MainHeader);
	    fprintf(file, "\n");
		    
	}
	else if (use_flag == VGCUsage)
	{
	    fprintf(file, "\tfprintf(stderr,\"\\t-%s  %s  (%s",
                    line_info.variable, desc, ascii_name(line_info.typeflag));
	    if (line_info.typeflag == FloatOpt)
		  gw_print_bounds_float(file, &line_info, VGCUsage);
	    else if (line_info.typeflag == IntegerOpt)
		  gw_print_bounds_int(file, &line_info, VGCUsage);
	    fprintf(file, ")\\n\");\n");
	}
		
	index++;
    }

    /* 
     * print out any required toggles
     */
    while(toggle_count < gw_toggle_num)
    {
	toggle_ptr = gw_toggle[toggle_count];
	if (toggle_ptr->req == true)
	{
	     if (use_flag == Man1Usage)
             {
  	          fprintf(file, ".IP -%s 15\n", toggle_ptr->variable);
		  fprintf(file, "%s:\n.br\n", toggle_ptr->desc);
	          gw_print_toggle_vals(file, toggle_ptr, Man1Usage);
	     }
	     else if (use_flag == MainHeader)
	     {
  	          fprintf(file, " *%s-%s  %s\n *\t\t", whitespace,
			  toggle_ptr->variable, toggle_ptr->desc);
	          gw_print_toggle_vals(file, toggle_ptr, MainHeader);
	     }
	     else if (use_flag == VGCUsage)
	     {
  	          fprintf(file, "\tfprintf(stderr, \"\\t-%s  \");\n", 
			  toggle_ptr->variable);
  	          fprintf(file, "\tfprintf(stderr, \"%s\\n  \");\n", 
			  toggle_ptr->desc);
	          gw_print_toggle_vals(file, toggle_ptr, VGCUsage);
	     }

	     if (use_flag == Man1Usage)
	       fprintf(file, "\n");
	     else if (use_flag == MainHeader)
	       fprintf(file, "\n");
	     else if (use_flag == VGCUsage)
	       fprintf(file, "\tfprintf(stderr, \"\\n\");\n");

	}
	toggle_count++;
    }

    if (use_flag == MainHeader)
	fprintf(file, " *\n");
    else if (use_flag == VGCUsage)
	fprintf(file, "\tfprintf(stderr, \"\\n\");\n");

    /* 
     * print out required mutually exclusive groups
     */
    while (mut_excl_count < gw_mut_excl_num)
    {
        mut_excl_ptr = gw_mut_excl[mut_excl_count];
        if (mut_excl_ptr->type == true)  /* mut excl group is required */
	{
	    if (use_flag == Man1Usage)
	        fprintf(file, ".sp\n.ce\n-------------------------------\n");
	    mut_excl_ptr = mut_excl_ptr->next;
	    while (mut_excl_ptr != NULL)
	    {
	        index = mut_excl_ptr->index;
	        xvf_gen_parse(database[index], &line_info);
	        if (line_info.description != NULL)
	           desc = xvf_strcpy(line_info.description);
	        else
	           desc = xvf_strcpy(" ");

	        if (mut_excl_ptr->next != NULL)
		{
	            if (use_flag == Man1Usage)
	    	        fprintf(file, ".IP -%s 15\n%s\n.ce\n-OR-\n", 
				line_info.variable, desc);
		    else if (use_flag == MainHeader)
		    {
	    	        fprintf(file, " *%s-%s  %s ",
				whitespace, line_info.variable, desc);
	       		if (line_info.typeflag == FloatOpt)
		  	    gw_print_bounds_float(file, &line_info, MainHeader);
	       		else if (line_info.typeflag == IntegerOpt)
		    	    gw_print_bounds_int(file, &line_info, MainHeader);
	       		fprintf(file, "   -OR-\n");
		    }
		    else if (use_flag == VGCUsage)
		    {
                        fprintf(file, "\tfprintf(stderr,\"\\t-%s  %s  (%s", 
	                        line_info.variable, desc, 
	   	                ascii_name(line_info.typeflag));
	       		if (line_info.typeflag == FloatOpt)
		  	    gw_print_bounds_float(file, &line_info, VGCUsage);
	       		else if (line_info.typeflag == IntegerOpt)
		    	    gw_print_bounds_int(file, &line_info, VGCUsage);
	    		fprintf(file, ") -OR- \\n\");\n");
		    }
		}
	        else
		{
	            if (use_flag == Man1Usage)
	  	        fprintf(file, ".IP -%s 15\n%s\n", 
				line_info.variable, desc);
		    else if (use_flag == MainHeader)
		    {
			fprintf(file, " *%s-%s  %s", whitespace,
				line_info.variable, desc);
	       		if (line_info.typeflag == FloatOpt)
		  	    gw_print_bounds_float(file, &line_info, MainHeader);
	       		else if (line_info.typeflag == IntegerOpt)
		  	    gw_print_bounds_int(file, &line_info, MainHeader);
	       		fprintf(file, "\n");
		    }
		    else if (use_flag == VGCUsage)
		    {
                        fprintf(file, "\tfprintf(stderr,\"\\t-%s  %s  (%s", 
	                        line_info.variable, desc, 
	   	                ascii_name(line_info.typeflag));
	       		if (line_info.typeflag == FloatOpt)
		  	    gw_print_bounds_float(file, &line_info, VGCUsage);
	       		else if (line_info.typeflag == IntegerOpt)
		  	    gw_print_bounds_int(file, &line_info, VGCUsage);
		        fprintf(file, ") \\n\");\n");
		    }

		}
	        mut_excl_ptr = mut_excl_ptr->next;
	    }
	    if (use_flag == Man1Usage)
	        fprintf(file, ".ce\n-------------------------------\n.sp\n");
	}
	mut_excl_count++;
    }

    /* 
     * print out optional arguments 
     */
    if (use_flag == MainHeader)
       fprintf(file, " *\n");
    else if (use_flag == VGCUsage)
	fprintf(file, "\tfprintf(stderr, \"\\n\");\n");

    index = 0;
    while (index < gw_num_opt)
    {
        xvf_gen_parse(database[gw_opt_args[index]], &line_info);
	if (line_info.description != NULL)
	   desc = xvf_strcpy(line_info.description);
	else
	   desc = xvf_strcpy(" ");
        if (use_flag == Man1Usage)
              fprintf(file, ".IP [-%s] 15\n%s\n", 
		      line_info.variable, desc);
	else if (use_flag == MainHeader)
	{
               fprintf(file, " *%s[-%s] %s", whitespace,
		      line_info.variable, desc);
	       if (line_info.typeflag == FloatOpt)
		  gw_print_bounds_float(file, &line_info, MainHeader);
	       else if (line_info.typeflag == IntegerOpt)
		  gw_print_bounds_int(file, &line_info, MainHeader);
	       fprintf(file, "\n");
	}
	else if (use_flag == VGCUsage)
        {
            fprintf(file, "\tfprintf(stderr,\"\\t[-%s]  %s (%s",
	            line_info.variable, desc, 
	    	    ascii_name(line_info.typeflag));
	    if (line_info.typeflag == FloatOpt)
		  gw_print_bounds_float(file, &line_info, VGCUsage);
	    else if (line_info.typeflag == IntegerOpt)
		  gw_print_bounds_int(file, &line_info, VGCUsage);
	    fprintf(file, ") [%s]\\n\");\n", ascii_def_val(&line_info));
	}
	index++;
    }

    /* 
     * print out any optional toggles
     */
    toggle_count = 0;
    while(toggle_count < gw_toggle_num)
    {
	toggle_ptr = gw_toggle[toggle_count];
	if (toggle_ptr->req == false)
	{
	     if (use_flag == Man1Usage)
	     {
  	          fprintf(file, ".IP [-%s] 15\n%s:\n.br\n", 
			  toggle_ptr->variable, toggle_ptr->desc);
	          gw_print_toggle_vals(file, toggle_ptr, Man1Usage);
		  fprintf(file, "   [default = %s]\n", 
			        ascii_def_toggle_value(toggle_ptr));
	     }
	     else if (use_flag == MainHeader)
	     {
  	          fprintf(file, " *%s[-%s] %s\n *\t\t", whitespace,
				toggle_ptr->variable, toggle_ptr->desc);
	          gw_print_toggle_vals(file, toggle_ptr, MainHeader);
		  fprintf(file, "  [default = %s] ", 
				 ascii_def_toggle_value(toggle_ptr));
	     }
	     if (use_flag == VGCUsage)
	     {
  	          fprintf(file, "\tfprintf(stderr, \"\\t[-%s]  %s\\n\");\n", 
			  toggle_ptr->variable, toggle_ptr->desc);
	          gw_print_toggle_vals(file, toggle_ptr, VGCUsage);
		  fprintf(file, "\tfprintf(stderr, \"\\t\\t[default = %s]\\n\");\n",
			        ascii_def_toggle_value(toggle_ptr));
	     }

	     if (use_flag == Man1Usage)
	       fprintf(file, "\n.br\n", whitespace);
	     else if (use_flag == MainHeader)
	       fprintf(file, "\n");
	     else if (use_flag == VGCUsage)
	       fprintf(file, "\tfprintf(stderr, \"\\n\");");
	}
	toggle_count++;
    }

    /* 
     * print out any optional mutually exclusive groups
     */
    if (use_flag == MainHeader)
        fprintf(file, " *\n");
    else if (use_flag == VGCUsage)
        fprintf(file, "\tfprintf(stderr, \" \\n\");\n");

    mut_excl_count = 0;
    while (mut_excl_count < gw_mut_excl_num)
    {
        mut_excl_ptr = gw_mut_excl[mut_excl_count];
        if (mut_excl_ptr->type == false)  /* mut excl group is optional */
	{
            if (use_flag == Man1Usage)
	         fprintf(file, ".sp\n", whitespace);
            if (use_flag == MainHeader)
	         fprintf(file, " *%s[", whitespace);
	    else if (use_flag == VGCUsage)
	         fprintf(file, "\tfprintf(stderr, \"\\t[ \");\n");
	    mut_excl_ptr = mut_excl_ptr->next;
	    while (mut_excl_ptr != NULL)
	    {
	        index = mut_excl_ptr->index;
	        xvf_gen_parse(database[index], &line_info);
	        if (line_info.description != NULL)
	           desc = xvf_strcpy(line_info.description);
	        else
	           desc = xvf_strcpy(" ");
	        if (mut_excl_ptr == gw_mut_excl[mut_excl_count]->next)
	        {
                    if (use_flag == Man1Usage)
	    	        fprintf(file, ".IP [-%s] 15\n%s\n.ce\n-OR-\n",
				line_info.variable, desc);
    		    else if (use_flag == MainHeader)
		    {
	    	        fprintf(file, "-%s  %s  ", line_info.variable, desc);
	       		if (line_info.typeflag == FloatOpt)
		  	    gw_print_bounds_float(file, &line_info, MainHeader);
	       		else if (line_info.typeflag == IntegerOpt)
		  	    gw_print_bounds_int(file, &line_info, MainHeader);
	       		fprintf(file, " -OR-\n");
		    }
		    else if (use_flag == VGCUsage)
		    {
                        fprintf(file, "\tfprintf(stderr,\"-%s  %s  (%s", 
	                        line_info.variable, desc, 
	   	                ascii_name(line_info.typeflag));
	       		if (line_info.typeflag == FloatOpt)
		  	    gw_print_bounds_float(file, &line_info, VGCUsage);
	       		else if (line_info.typeflag == IntegerOpt)
		    	    gw_print_bounds_int(file, &line_info, VGCUsage);
		        fprintf(file, ") -OR- \\n\");\n");
		    }
			
	        }
	        else if (mut_excl_ptr->next != NULL)
		{
                    if (use_flag == Man1Usage)
	    	        fprintf(file, ".IP  [-%s] 15\n%s\n.ce\n-OR-\n",
				line_info.variable, desc);
    		    else if (use_flag == MainHeader)
		    {
	    	        fprintf(file, " *%s -%s  %s ", whitespace,
				line_info.variable, desc);
	       		if (line_info.typeflag == FloatOpt)
		  	    gw_print_bounds_float(file, &line_info, MainHeader);
	       		else if (line_info.typeflag == IntegerOpt)
		  	    gw_print_bounds_int(file, &line_info, MainHeader);
	       		fprintf(file, " -OR-\n");
		    }
		    else if (use_flag == VGCUsage)
		    {
                        fprintf(file, "\tfprintf(stderr,\"\\t  -%s  %s  (%s", 
	                        line_info.variable, desc, 
	   	                ascii_name(line_info.typeflag));
	       		if (line_info.typeflag == FloatOpt)
		  	    gw_print_bounds_float(file, &line_info, VGCUsage);
	       		else if (line_info.typeflag == IntegerOpt)
		  	    gw_print_bounds_int(file, &line_info, VGCUsage);
		        fprintf(file, ") -OR- \\n\");\n");
		    }
		}
	        else
		{
                    if (use_flag == Man1Usage)
	  	        fprintf(file, ".IP  [-%s] 15\n%s\n", 
				line_info.variable, desc);
    		    else if (use_flag == MainHeader)
		    {
	  	        fprintf(file, " * %s-%s  %s  ", whitespace,
				line_info.variable, desc);
	       		if (line_info.typeflag == FloatOpt)
		        {
		  	   gw_print_bounds_float(file, &line_info, MainHeader);
	       		   fprintf(file, ") ]\n *\n");
		        }
	       		else if (line_info.typeflag == IntegerOpt)
			{
		  	   gw_print_bounds_int(file, &line_info, MainHeader);
	       		   fprintf(file, ") ]\n *\n");
			}
			else fprintf(file, " ]\n *\n");
		    }
		    else if (use_flag == VGCUsage)
		    {
                        fprintf(file, "\tfprintf(stderr,\"\\t  -%s  %s  (%s", 
	                        line_info.variable, desc, 
	   	                ascii_name(line_info.typeflag));
	       		if (line_info.typeflag == FloatOpt)
		  	   gw_print_bounds_float(file, &line_info, VGCUsage);
	       		else if (line_info.typeflag == IntegerOpt)
		  	   gw_print_bounds_int(file, &line_info, VGCUsage);
		        fprintf(file, ") ]\\n\\n\");\n");
		    }

		}
	        mut_excl_ptr = mut_excl_ptr->next;
	    }
	}
	mut_excl_count++;
    }

    if (use_flag == MainHeader)
         fprintf(file, " *\n *\n");
    else if (use_flag == VGCUsage)
        fprintf(file, "\tfprintf(stderr, \"\\n\");\n");
}



/************************************************************
*
*  Routine Name: gw_find_string 
*
*      Purpose:  This routine returns 0 if the second input string
*                is contained in the first and 1 otherwise.
*
*        Input:  two character strings, a and b
*
*       Output:  returns 0 if b is a substring of a and 1 if not.
*
*    Called by:  gw_generate_man1file
*
*   Written By:  Per Lysne  9/26/90
*
*************************************************************/
int gw_find_string (a, b)
char *a, *b;
{
    int i, lena, lenb;

    if (a==NULL || b==NULL)
        return (1);

    lena=VStrlen(a);
    lenb=VStrlen(b);

    for (i=0; i<lena; i++) {
        if (strncmp(&a[i], b, lenb)==0)
            return (0);
    }

    return (1);
}
