 /*
  * Khoros: $Id: fill_pane.c,v 1.1 1991/05/10 15:58:12 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: fill_pane.c,v 1.1 1991/05/10 15:58:12 khoros Exp $";
#endif

 /*
  * $Log: fill_pane.c,v $
 * Revision 1.1  1991/05/10  15:58:12  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "composer.h"


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: fill_pane.c
 >>>>
 >>>>      Program Name: composer
 >>>> 
 >>>> Date Last Updated: Sat Jul  7 14:41:44 MDT 1990
 >>>>
 >>>>          Routines: fill_pane()  puts currently selected line 
 >>>>				information into the pane.
 >>>>
 >>>>		 Author:  John Rasure
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name:  fill_pane()
*       Purpose:  to take info from a UI spec line and put it into
*		the pane so that it can be edited
*         Input:  formptr and info contain form data structure and UI tree
*		  formptr - pointer to the xvform structure
*		  info - pointer for the structure for the edit_pane.
*		  line_number - index that specifies specific UI line

*        Output:  edit pane is filled out with selected line information
*
*     Called By:  run_edit_pane()
*
********************************************************/


void
fill_pane(formptr, info, line_number)
xvf_form 	*formptr;
pane_edit_pane  *info;
int		line_number;
{
    Line_Info 	line_info;
    char  	temp[MaxLength];
    int		type;	/* indicates what kind of line */

    if (line_number == NONE_SELECTED) type = NONE_SELECTED;
    else {
        type = xvf_get_line_type(gui_spec[line_number]);
        xvf_clear_line_info(&line_info);
    }

    switch (type) {
        case InputFile :
        case OutputFile :
            xvf_gen_parse(gui_spec[line_number], &line_info);

            xvf_change_input(formptr, info->button_label_index, 
              xvf_stringval_chng, line_info.title, 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_stringval_chng, line_info.description, 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_stringval_chng, line_info.file_def, 0);
        
            xvf_change_input(formptr, info->var_name_index, 
              xvf_stringval_chng, line_info.variable, 0);
        
            (void) sprintf(temp, "%d", line_info.activate);
            xvf_change_input(formptr, info->active_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.optional);
            xvf_change_input(formptr, info->optional_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.live);
            xvf_change_input(formptr, info->live_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.opt_sel);
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.width);
            xvf_change_input(formptr, info->gs_width_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.height);
            xvf_change_input(formptr, info->gs_height_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.x);
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.y);
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.xpos);
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.ypos);
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_intval_chng, temp, 0);

            break;

        case FloatOpt :
            xvf_gen_parse(gui_spec[line_number], &line_info);

            /* 	info->toggle_range_val = 1; */
	    if ( line_info.lower_float == -2 && line_info.upper_float == -2) {
	        (void) sprintf(temp, "%g", line_info.lower_float);
        	xvf_change_input(formptr, info->lower_range_index, 
          	                 xvf_floatval_chng, temp, 0);

	        (void) sprintf(temp, "%g", line_info.upper_float);
        	xvf_change_input(formptr, info->upper_range_index, 
          	                 xvf_floatval_chng, temp, 0);
	
        	xvf_change_input(formptr, info->toggle_range_index,
          	                  xvf_toggleval_chng, "1", 0);
    	    }
	
            /* 	info->toggle_range_val = 2; */
    	    else if ( line_info.lower_float == -1 && line_info.upper_float == -1) {
        	(void) sprintf(temp, "%g", line_info.lower_float);
        	xvf_change_input(formptr, info->lower_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	(void) sprintf(temp, "%g", line_info.upper_float);
        	xvf_change_input(formptr, info->upper_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	xvf_change_input(formptr, info->toggle_range_index,
          	                   xvf_toggleval_chng, "2", 0);
    	    }
	
            /* 	info->toggle_range_val = 3; */
    	    else if ( line_info.lower_float == 2 && line_info.upper_float == 2) {
        	(void) sprintf(temp, "%g", line_info.lower_float);
        	xvf_change_input(formptr, info->lower_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	(void) sprintf(temp, "%g", line_info.upper_float);
        	xvf_change_input(formptr, info->upper_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	xvf_change_input(formptr, info->toggle_range_index,
          	                   xvf_toggleval_chng, "3", 0);
    	    }
	
            /* 	info->toggle_range_val = 4; */
    	    else if ( line_info.lower_float == 1 && line_info.upper_float == 1) {
        	(void) sprintf(temp, "%g", line_info.lower_float);
        	xvf_change_input(formptr, info->lower_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	(void) sprintf(temp, "%g", line_info.upper_float);
        	xvf_change_input(formptr, info->upper_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	xvf_change_input(formptr, info->toggle_range_index,
          	                   xvf_toggleval_chng, "4", 0);
    	    }
	
            /* 	info->toggle_range_val = 6; */
    	    else if ( line_info.lower_float == line_info.upper_float ) {
        	(void) sprintf(temp, "%g", line_info.lower_float);
        	xvf_change_input(formptr, info->lower_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	(void) sprintf(temp, "%g", line_info.upper_float);
        	xvf_change_input(formptr, info->upper_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	xvf_change_input(formptr, info->toggle_range_index,
          	                   xvf_toggleval_chng, "6", 0);
    	    }
	
            /* 	info->toggle_range_val = 5; */
    	    else {
        	(void) sprintf(temp, "%g", line_info.lower_float);
        	xvf_change_input(formptr, info->lower_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	(void) sprintf(temp, "%g", line_info.upper_float);
        	xvf_change_input(formptr, info->upper_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	xvf_change_input(formptr, info->toggle_range_index,
          	                   xvf_toggleval_chng, "5", 0);
    	    }

            xvf_change_input(formptr, info->button_label_index, 
              xvf_stringval_chng, line_info.title, 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_stringval_chng, line_info.description, 0);

            (void) sprintf(temp, "%g", line_info.float_def);
            xvf_change_input(formptr, info->default_float_index,
              xvf_floatval_chng, temp, 0);
        
            xvf_change_input(formptr, info->var_name_index, 
              xvf_stringval_chng, line_info.variable, 0);
        
            (void) sprintf(temp, "%d", line_info.activate);
            xvf_change_input(formptr, info->active_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.optional);
            xvf_change_input(formptr, info->optional_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.live);
            xvf_change_input(formptr, info->live_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.opt_sel);
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.width);
            xvf_change_input(formptr, info->gs_width_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.height);
            xvf_change_input(formptr, info->gs_height_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.x);
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.y);
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.xpos);
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.ypos);
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_intval_chng, temp, 0);

            break;

        case IntegerOpt :
            xvf_gen_parse(gui_spec[line_number], &line_info);

            /* 	info->toggle_range_val = 1; */
	    if ( line_info.lower_int == -2 && line_info.upper_int == -2) {
	        (void) sprintf(temp, "%d", line_info.lower_int);
        	xvf_change_input(formptr, info->lower_range_index, 
          	                 xvf_floatval_chng, temp, 0);

	        (void) sprintf(temp, "%d", line_info.upper_int);
        	xvf_change_input(formptr, info->upper_range_index, 
          	                 xvf_floatval_chng, temp, 0);
	
        	xvf_change_input(formptr, info->toggle_range_index,
          	                  xvf_toggleval_chng, "1", 0);
    	    }
	
            /* 	info->toggle_range_val = 2; */
    	    else if ( line_info.lower_int == -1 && line_info.upper_int == -1) {
        	(void) sprintf(temp, "%d", line_info.lower_int);
        	xvf_change_input(formptr, info->lower_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	(void) sprintf(temp, "%d", line_info.upper_int);
        	xvf_change_input(formptr, info->upper_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	xvf_change_input(formptr, info->toggle_range_index,
          	                   xvf_toggleval_chng, "2", 0);
    	    }
	
            /* 	info->toggle_range_val = 3; */
    	    else if ( line_info.lower_int == 2 && line_info.upper_int == 2) {
        	(void) sprintf(temp, "%d", line_info.lower_int);
        	xvf_change_input(formptr, info->lower_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	(void) sprintf(temp, "%d", line_info.upper_int);
        	xvf_change_input(formptr, info->upper_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	xvf_change_input(formptr, info->toggle_range_index,
          	                   xvf_toggleval_chng, "3", 0);
    	    }
	
            /* 	info->toggle_range_val = 4; */
    	    else if ( line_info.lower_int == 1 && line_info.upper_int == 1) {
        	(void) sprintf(temp, "%d", line_info.lower_int);
        	xvf_change_input(formptr, info->lower_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	(void) sprintf(temp, "%d", line_info.upper_int);
        	xvf_change_input(formptr, info->upper_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	xvf_change_input(formptr, info->toggle_range_index,
          	                   xvf_toggleval_chng, "4", 0);
    	    }
	
            /* 	info->toggle_range_val = 6; */
    	    else if ( line_info.lower_int == line_info.upper_int ) {
        	(void) sprintf(temp, "%d", line_info.lower_int);
        	xvf_change_input(formptr, info->lower_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	(void) sprintf(temp, "%d", line_info.upper_int);
        	xvf_change_input(formptr, info->upper_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	xvf_change_input(formptr, info->toggle_range_index,
          	                   xvf_toggleval_chng, "6", 0);
    	    }
	
            /* 	info->toggle_range_val = 5; */
    	    else {
        	(void) sprintf(temp, "%d", line_info.lower_int);
        	xvf_change_input(formptr, info->lower_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	(void) sprintf(temp, "%d", line_info.upper_int);
        	xvf_change_input(formptr, info->upper_range_index, 
          	                   xvf_floatval_chng, temp, 0);
	
        	xvf_change_input(formptr, info->toggle_range_index,
          	                   xvf_toggleval_chng, "5", 0);
    	    }

            xvf_change_input(formptr, info->button_label_index, 
              xvf_stringval_chng, line_info.title, 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_stringval_chng, line_info.description, 0);

            (void) sprintf(temp, "%d", line_info.int_def);
            xvf_change_input(formptr, info->default_float_index,
              xvf_floatval_chng, temp, 0);
        
            xvf_change_input(formptr, info->var_name_index, 
              xvf_stringval_chng, line_info.variable, 0);
        
            (void) sprintf(temp, "%d", line_info.activate);
            xvf_change_input(formptr, info->active_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.optional);
            xvf_change_input(formptr, info->optional_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.live);
            xvf_change_input(formptr, info->live_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.opt_sel);
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.width);
            xvf_change_input(formptr, info->gs_width_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.height);
            xvf_change_input(formptr, info->gs_height_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.x);
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.y);
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.xpos);
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.ypos);
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_intval_chng, temp, 0);
            break;

        case StringOpt :
            xvf_gen_parse(gui_spec[line_number], &line_info);

            xvf_change_input(formptr, info->button_label_index, 
              xvf_stringval_chng, line_info.title, 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_stringval_chng, line_info.description, 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_stringval_chng, line_info.string_def, 0);
        
            xvf_change_input(formptr, info->var_name_index, 
              xvf_stringval_chng, line_info.variable, 0);
        
            (void) sprintf(temp, "%d", line_info.activate);
            xvf_change_input(formptr, info->active_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.optional);
            xvf_change_input(formptr, info->optional_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.live);
            xvf_change_input(formptr, info->live_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.opt_sel);
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.width);
            xvf_change_input(formptr, info->gs_width_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.height);
            xvf_change_input(formptr, info->gs_height_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.x);
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.y);
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.xpos);
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.ypos);
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_intval_chng, temp, 0);

            break;

        case LogicOpt :
            xvf_gen_parse(gui_spec[line_number], &line_info);

            xvf_change_input(formptr, info->button_label_index, 
              xvf_stringval_chng, line_info.title, 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_stringval_chng, line_info.description, 0);

            xvf_change_input(formptr, info->var_name_index, 
              xvf_stringval_chng, line_info.variable, 0);
        
            xvf_change_input(formptr, info->one_label_index, 
              xvf_stringval_chng, line_info.val_labels[1], 0);
        
            xvf_change_input(formptr, info->zero_label_index, 
              xvf_stringval_chng, line_info.val_labels[0], 0);
        
            (void) sprintf(temp, "%d", line_info.logical_def);
            xvf_change_input(formptr, info->default_logical_index,
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.activate);
            xvf_change_input(formptr, info->active_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.optional);
            xvf_change_input(formptr, info->optional_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.live);
            xvf_change_input(formptr, info->live_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.opt_sel);
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.width);
            xvf_change_input(formptr, info->gs_width_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.height);
            xvf_change_input(formptr, info->gs_height_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.x);
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.y);
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.xpos);
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.ypos);
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_intval_chng, temp, 0);

            break;

        case HelpSel :
            xvf_gen_parse(gui_spec[line_number], &line_info);

            xvf_change_input(formptr, info->button_label_index, 
              xvf_stringval_chng, line_info.title, 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_stringval_chng, line_info.description, 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_stringval_chng, line_info.help_file, 0);
        
            (void) sprintf(temp, "%d", line_info.activate);
            xvf_change_input(formptr, info->active_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.width);
            xvf_change_input(formptr, info->gs_width_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.height);
            xvf_change_input(formptr, info->gs_height_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.x);
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.y);
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.xpos);
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.ypos);
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_intval_chng, temp, 0);

            break;

        case QuitForm :
            xvf_gen_parse(gui_spec[line_number], &line_info);

            xvf_change_input(formptr, info->button_label_index, 
              xvf_stringval_chng, line_info.title, 0);

            (void) sprintf(temp, "%d", line_info.activate);
            xvf_change_input(formptr, info->active_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.width);
            xvf_change_input(formptr, info->gs_width_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.height);
            xvf_change_input(formptr, info->gs_height_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.x);
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.y);
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.xpos);
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.ypos);
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_intval_chng, temp, 0);

            break;

        case Routine :
            xvf_gen_parse(gui_spec[line_number], &line_info);

            xvf_change_input(formptr, info->button_label_index, 
              xvf_stringval_chng, line_info.title, 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_stringval_chng, line_info.routine, 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_stringval_chng, line_info.description, 0);

            (void) sprintf(temp, "%d", line_info.activate);
            xvf_change_input(formptr, info->active_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.width);
            xvf_change_input(formptr, info->gs_width_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.height);
            xvf_change_input(formptr, info->gs_height_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.x);
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.y);
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.xpos);
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.ypos);
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_intval_chng, temp, 0);

            break;

        case PaneAction :
            xvf_gen_parse(gui_spec[line_number], &line_info);

            xvf_change_input(formptr, info->var_name_index, 
              xvf_stringval_chng, line_info.variable, 0);

            xvf_change_input(formptr, info->button_label_index, 
              xvf_stringval_chng, line_info.title, 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_stringval_chng, line_info.description, 0);

            (void) sprintf(temp, "%d", line_info.activate);
            xvf_change_input(formptr, info->active_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.width);
            xvf_change_input(formptr, info->gs_width_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.height);
            xvf_change_input(formptr, info->gs_height_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.x);
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.y);
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.xpos);
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.ypos);
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_intval_chng, temp, 0);

            break;

        case StartPane :
            xvf_gen_parse(gui_spec[line_number], &line_info);

            xvf_change_input(formptr, info->button_label_index, 
              xvf_stringval_chng, line_info.title, 0);

            xvf_change_input(formptr, info->name_index, 
              xvf_stringval_chng, line_info.variable, 0);

            (void) sprintf(temp, "%d", line_info.activate);
            xvf_change_input(formptr, info->active_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.width);
            xvf_change_input(formptr, info->gs_width_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.height);
            xvf_change_input(formptr, info->gs_height_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.x);
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.y);
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.xpos);
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.ypos);
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_intval_chng, temp, 0);

            break;

        case MutExcl :
            xvf_gen_parse(gui_spec[line_number], &line_info);

            (void) sprintf(temp, "%d", line_info.logical_val);
            xvf_change_input(formptr, info->optional_index, 
              xvf_logicalval_chng, temp, 0);

            break;

        case Toggle :
            xvf_gen_parse(gui_spec[line_number], &line_info);

            xvf_change_input(formptr, info->button_label_index, 
              xvf_stringval_chng, line_info.title, 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_stringval_chng, line_info.description, 0);

            xvf_change_input(formptr, info->var_name_index, 
              xvf_stringval_chng, line_info.variable, 0);
        
            (void) sprintf(temp, "%d", line_info.activate);
            xvf_change_input(formptr, info->active_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.optional);
            xvf_change_input(formptr, info->optional_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.live);
            xvf_change_input(formptr, info->live_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%d", line_info.opt_sel);
            xvf_change_input(formptr, info->opt_selected_index, 
              xvf_logicalval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.width);
            xvf_change_input(formptr, info->gs_width_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.height);
            xvf_change_input(formptr, info->gs_height_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.x);
            xvf_change_input(formptr, info->gs_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.y);
            xvf_change_input(formptr, info->gs_yoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.xpos);
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.ypos);
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_intval_chng, temp, 0);

            break;

        case Blank :
            xvf_gen_parse(gui_spec[line_number], &line_info);

            xvf_change_input(formptr, info->button_label_index, 
              xvf_stringval_chng, line_info.title, 0);

            (void) sprintf(temp, "%g", line_info.xpos);
            xvf_change_input(formptr, info->ps_xoff_index,
              xvf_intval_chng, temp, 0);
        
            (void) sprintf(temp, "%g", line_info.ypos);
            xvf_change_input(formptr, info->ps_yoff_index,
              xvf_intval_chng, temp, 0);

            break;
        case NONE_SELECTED :

            xvf_change_input(formptr, info->button_label_index, 
              xvf_stringval_chng, " ", 0);

            xvf_change_input(formptr, info->usage_string_index, 
              xvf_stringval_chng, " ", 0);

            xvf_change_input(formptr, info->default_string_index, 
              xvf_stringval_chng, " ", 0);
        
            xvf_change_input(formptr, info->var_name_index, 
              xvf_stringval_chng, " ", 0);
        
            break;

        default :
            (void) sprintf(temp, "Unknow user interface specification line type.");
            xvf_error_wait(temp, "COMPOSER WARNING!", "OK");
            break;
    }
}
