 /*
  * Khoros: $Id: query.c,v 1.2 1991/12/18 09:17:03 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: query.c,v 1.2 1991/12/18 09:17:03 dkhoros Exp $";
#endif

 /*
  * $Log: query.c,v $
 * Revision 1.2  1991/12/18  09:17:03  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xvutils.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    	    file name: query.c                        <<<<
   >>>>                                                       <<<<
   >>>>         Creates a Query Widget			      <<<<
   >>>>                                                       <<<<
   >>>>             xvf_query_wait()			      <<<<              
   >>>>             xvf_create_query()			      <<<<              
   >>>>             xvf_quit_query()			      <<<<              
   >>>>             xvf_cancel_query()			      <<<<              
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

char search_trans_table1[] =
"<Key>0xff0d:   beginning-of-file() \n\
Ctrl<Key>x:    beginning-of-file()";


/************************************************************
*
*  Routine Name:  xvf_query_wait()
*
*      Purpose:   creates a form to get a single line 
*		  response from the user.  
*                 NOTE: this routine will grab all events 
*                 while running.  
*
*        Input:   top_label    - label to appear at top of query widget
*		  prompts[]    - array of strings: prompts, one 
*			         for each of num_prompts 
*			         for the information.
*                 button       - label for button for user to say 
*			         "I'm done entering my responses".
*		  answers[]    - array of strings in which to return the
*				 user's responses, one for each of num_prompts
*		  num_prompts  - size of prompts[] and answers[] arrays
*		  size	       - size to make each text widget for the
*				 user's response
*
*       Output:   returns the information the user typed in.
*                 QUERY_SIG (global variable) will contain 1 if user
*                 selected "OK" button or 0 if selected "CANCEL".
*
*    Called By:   the application program
*
*   Written By:   Stephanie Hallett
*
*   Modified By:  Carla Williams
*		  1/31/90  CANCEL button added to query form
*		  (returns NULL)
*
*************************************************************/

char *xvf_query_wait(top_label,prompts,button,answers,num_prompts, size)
char *top_label;
char *prompts[];
char *button;
char *answers[];
int  num_prompts;
int  size;
{
   char *hold;
   Widget toplevel, xvf_create_query();

   QUERY_DONE = false;

   toplevel  = xvf_create_query(top_label,prompts,button,answers,
		num_prompts, size);
 
   if (toplevel == NULL)
      return(NULL);

   while(!QUERY_DONE)
   {
      xvf_process_event();      /* this does XtNextEvent/DispatchEvent*/
   }

   /*
    * delete the query box's toplevel from the list 
    * used by journal playback before destroying it
    * if they gave a response in the answers box, return it.
    */
   if (QUERY_SIG == 0)
   {
      xvf_delete_toplevel(toplevel);
      XtUnmapWidget(toplevel);
      XtDestroyWidget(toplevel);
      return(NULL);
   }
   else
   {
      if (answers[0] != NULL)
         hold = xvf_strcpy(answers[0]);
      xvf_delete_toplevel(toplevel);
      XtUnmapWidget(toplevel);
      XtDestroyWidget(toplevel);
      return(hold);
   }
}


/************************************************************
*
*  Routine Name:  xvf_create_query(top_label,prompts,button,
*				   answers, num_prompts, size)
*
*      Purpose:   Does the  actual creation of a query widget. 
*		  The query widget consists of a form widget with a 
*		  label, and "num prompts" set of prompts with answer widgets.
*
*        Input:   top_label    - label to appear at top of query widget
*		  prompts[]    - array of strings: prompts, one 
*			         for each of num_prompts 
*			         for the information.
*                 button       - label for button for user to say 
*			         "I'm done entering my responses".
*		  answers[]    - array of strings in which to return the
*				 user's responses, one for each of num_prompts
*		  num_prompts  - size of prompts[] and answers[] arrays
*		  size	       - size to make each text widget for the
*				 user's response
*
*       Output:   wait to user to enter values & acknowledge message.
*
*    Called By:   xvf_error_wait() or the application program
*
*   Written By:   Danielle Argiro Stephanie Hallett
*
*************************************************************/

#define MaxNumQuerysInViewport 10 

Widget xvf_create_query(top_label, prompts, button, answers,
		        num_prompts, size)
char *top_label;
char *prompts[];
char *button;
char *answers[];
int  num_prompts, size;
{
   Widget toplevel;		/* toplevel widget */
   Widget formback;		/* form backplane for query form */
   Widget viewport;		/* viewport backplane for query form */
   Widget queryback;		/* query backplane for prompts & responses */
   Widget top_label_wid;	/* initial label */
   Widget *label;		/* array of labels for prompts */
   Widget *text;		/* array of text widgets to get answers */
   Widget ok_wid;		/* button to get rid of query */
   Widget cancel_wid;		/* button to cancel query */
   Arg    arg[MaxArgs];
   void   xvf_quit_query(), xvf_cancel_query();
   XtTranslations translations;
   int    i, n, width, prompt_width=0; 
   int    label_width, ok_width, cancel_width, viewport_height;
   char name[MaxLength];
   char *top_name, *cap_top_name;

   /*
    *  allocate space for answers array, text & label arrays
    */
    for (i = 0; i < num_prompts; i++)
    	if (answers[i] == NULL)
	    answers[i] = (char *) malloc(125*sizeof(char));

    label = (Widget *) malloc(num_prompts*sizeof(Widget)); 
    text  = (Widget *) malloc(num_prompts*sizeof(Widget)); 

   /*
    * create identifying widget name
    */
   sprintf(name,"%d_query",Query_cnt);
   Query_cnt++;
   top_name = xvf_strcpy(name);
   cap_top_name = xvf_cap_first_letter(top_name);

    if (top_label == NULL)
    {
        top_label = xvf_strcpy("Please Respond");
        label_width = 15*xvf_font_width;
    }
    else
        label_width = find_string_width(top_label)*xvf_font_width;

   /*
    * determine size of longest prompt (in pixels);
    */
    for (i = 0; i < num_prompts; i++)
    {
	width = xvf_strlen(prompts[i])*xvf_font_width;
        if (width > prompt_width) prompt_width = width;
    }
    prompt_width = prompt_width + xvf_font_width;

   /*
    * determine size of ok widget (in pixels);
    */
     if (button == NULL)
     {
         ok_width = 3*xvf_font_width;
	 button = xvf_strcpy("Ok");
     }
     else
         ok_width = (xvf_strlen(button)+1)*xvf_font_width;

   /*
    * determine size of cancel widget (in pixels);
    */
    cancel_width = 7*xvf_font_width;

   /*
    * create the query box's toplevel widget, and add it
    * to the list of toplevels that is used with journal playback.
    */
   i = 0;
   XtSetArg(arg[i], XtNscreen, xvf_screen);		 i++;
   XtSetArg(arg[i], XtNargc, xvf_ac); 	                 i++;
   XtSetArg(arg[i], XtNargv, xvf_av);	          	 i++; 
   XtSetArg(arg[i], XtNinput, true);	          	 i++; 
   toplevel = XtAppCreateShell(top_name,cap_top_name,
				transientShellWidgetClass,
				xvf_display, arg, i);
   xvf_add_toplevel(toplevel);


   /* 
    * create the backplane widget 
    */ 
   n = 0;
   XtSetArg(arg[n],XtNmappedWhenManaged,True);	n++;
   XtSetArg(arg[n],XtNborderWidth,1); 		n++;
   XtSetArg(arg[n],XtNdefaultDistance,4);	n++; 
   formback = XtCreateManagedWidget("query_back",formWidgetClass,
				      toplevel,arg,n);

   /* 
    * create the label widget 
    */ 
    width = prompt_width+size*xvf_font_width 
		  - ok_width - cancel_width - LEFT_MARGIN;
    if (width > label_width) label_width = width;
    n = 0;
    XtSetArg(arg[n],XtNlabel,xvf_strcpy(top_label));	n++;
    if (xvf_font != NULL)
    {
        XtSetArg(arg[n],XtNfont,xvf_font);             		n++;
    }
    XtSetArg(arg[n],XtNborderWidth,0); 			        n++;
    XtSetArg(arg[n],XtNwidth, (Dimension) label_width);		n++;
    top_label_wid = XtCreateManagedWidget("label",labelWidgetClass,
				      formback,arg,n);

   /* 
    * create the viewport widget which will 
    * provide backplane with scroll bar
    */ 
   if (num_prompts < MaxNumQuerysInViewport) 
	viewport_height = num_prompts;
   else viewport_height = MaxNumQuerysInViewport;
    
   i = 0;
   XtSetArg(arg[i], XtNallowVert, True); 	                i++;
   XtSetArg(arg[i], XtNforceBars, True); 	                i++;
   XtSetArg(arg[i], XtNfromVert, top_label_wid); 	        i++;
   XtSetArg(arg[i], XtNheight, xvf_font_height*(2*viewport_height)); i++;
   XtSetArg(arg[i], XtNx, xvf_font_height); i++;
   viewport = XtCreateManagedWidget("query_view_back",viewportWidgetClass,
				      formback,arg,i);

   /* 
    * create the backplane widget for prompts & responses
    */ 
   n = 0;
   XtSetArg(arg[n],XtNmappedWhenManaged,True);	n++;
   XtSetArg(arg[n],XtNborderWidth,1); 		n++;
   XtSetArg(arg[n],XtNdefaultDistance,4);	n++; 
   queryback = XtCreateManagedWidget("query_query_back",formWidgetClass,
				      viewport,arg,n);
   /*
    *  create the entire set of prompt & answer widget pairs
    */
   for (i = 0; i < num_prompts; i++)
   {
	n = 0;
        /* create label widget */
	sprintf(name,"%d_label",i);
        if (prompts[i] == NULL)
        {  
           fprintf(stderr,"xvf_create_query: need a valid label\n");
           return(NULL);
        }
        if (i != 0)
	{
	  XtSetArg(arg[n],XtNfromVert,text[i-1]);		n++;
	}
	XtSetArg(arg[n],XtNfromHoriz, NULL);			n++;
        XtSetArg(arg[n],XtNlabel,xvf_strcpy(prompts[i])); 	n++;
        XtSetArg(arg[n],XtNwidth,(Dimension) prompt_width);	n++;
        XtSetArg(arg[n],XtNmappedWhenManaged,True);		n++;
        XtSetArg(arg[n],XtNborderWidth, 0);			n++;
        if (xvf_font != NULL)
        {
            XtSetArg(arg[n],XtNfont,xvf_font);             	n++;
        }
        label[i] = XtCreateManagedWidget(xvf_strcpy(name),
      	         labelWidgetClass,queryback,arg,n);	

        /* create text widget */
	sprintf(name,"%d_text",i);
	n = 0;
        if (i != 0)
	{
	  XtSetArg(arg[n],XtNfromVert,text[i-1]);	n++;
	}
        if (xvf_font != NULL)
        {
            XtSetArg(arg[n],XtNfont,xvf_font);        	n++;
        }
	XtSetArg(arg[n],XtNfromHoriz,label[i]);       	n++;	
        XtSetArg(arg[n],XtNeditType,XawtextEdit);	n++;
        XtSetArg(arg[n],XtNtype,    XawAsciiString);	n++;
        XtSetArg(arg[n],XtNstring,answers[i]);		n++;
        XtSetArg(arg[n],XtNuseStringInPlace, true);	n++;
        XtSetArg(arg[n],XtNwidth ,(Dimension)size*xvf_font_width);	n++;
        XtSetArg(arg[n],XtNlength,512);			n++;
        XtSetArg(arg[n],XtNleftMargin,LEFT_MARGIN);	n++;
        text[i] =  XtCreateManagedWidget(xvf_strcpy(name),
		asciiTextWidgetClass, queryback,arg,n);
        translations = XtParseTranslationTable(search_trans_table1);
        XtOverrideTranslations(text[i], translations);
   }

   /* 
    * create ok button 
    */
   n = 0;
   XtSetArg(arg[n],XtNfromHoriz,top_label_wid);	  	  n++;
   XtSetArg(arg[n],XtNfromVert,NULL);	  	  	  n++;
   XtSetArg(arg[n],XtNlabel,xvf_strcpy(button)); 	  n++;
   if (xvf_font != NULL)
   {
      XtSetArg(arg[n],XtNfont,xvf_font);             	  n++;
   }
   XtSetArg(arg[n], XtNwidth, (Dimension) ok_width);      n++;
   ok_wid = XtCreateManagedWidget("ok_wid",
				    commandWidgetClass,formback,arg,n);
   XtAddCallback(ok_wid,XtNcallback,xvf_quit_query,toplevel);


   /* 
    * create cancel button 
    */
   n = 0;
   XtSetArg(arg[n],XtNfromVert,NULL);	  		  n++;
   XtSetArg(arg[n],XtNfromHoriz,ok_wid);		  n++;
   XtSetArg(arg[n],XtNlabel,"Cancel");                    n++;
   XtSetArg(arg[n], XtNwidth, (Dimension) cancel_width);  n++;
   if (xvf_font != NULL)
   {
       XtSetArg(arg[n],XtNfont,xvf_font);             	  n++;
   }
   cancel_wid = XtCreateManagedWidget("cancel_wid",
	commandWidgetClass,formback,arg,n);
   XtAddCallback(cancel_wid,XtNcallback,xvf_cancel_query,toplevel);

   xvf_add_protocol_handler(toplevel, "WM_DELETE_WINDOW", 
			    xvf_cancel_query, toplevel);

   xvf_place_widget(toplevel, NULL);
   return(toplevel);
}


/* callbacks used to exit query */


void xvf_quit_query(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
   QUERY_DONE = true;
   QUERY_SIG = 1;
}

void xvf_cancel_query(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
   Widget toplevel = (Widget) clientData;

   xvf_remove_protocol_handler(toplevel, "WM_DELETE_WINDOW", 
			       xvf_cancel_query, toplevel);
   QUERY_DONE = true;
   QUERY_SIG = 0;
}

