 /*
  * Khoros: $Id: parser.h,v 1.2 1991/10/02 00:17:40 khoros Exp $
  */

 /*
  * $Log: parser.h,v $
 * Revision 1.2  1991/10/02  00:17:40  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#ifndef _parser_h_
#define _parser_h_

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>	     file: parser.h					 <<<<
   >>>>                                                          <<<<
   >>>>      contains: Parsing Scan Fields                       <<<<
   >>>>                                                          <<<<
   >>>>	     These scan fields define the model for each type    <<<<
   >>>>	     of User Interface Specification line that is        <<<<
   >>>>      read by xvf_parse_***_line()		         <<<< 
   >>>>                                                          <<<<
   >>>>      written by: Danielle Argiro & Stephanie Hallett,    <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

static char 

/* -F # @ % gs ps 'l' FormInfoName */
*startform_scan="-%c%d.%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%s",

/* -S @ mutually_exclusive */
*startmaster_scan= "-%c%d%d",

/* -M @ % gs ps 'l' SubFormInfoName */
*startsubform_scan= "-%c%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%s",   

/* -D @ % gs ps 'l' SubMenuInfoName */
*startsubmenu_scan= "-%c%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%s",   

/* -d @ % gs 'l'*/
*subformbutton_scan="-%c%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]", 

/* -u @ % gs 'l'*/
*psuedosubform_scan="-%c%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]", 

/* -n @ % gs 'l' 'des' v */
*master_action_scan = "-%c%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s",

/* -P @ % gs ps 'l' PaneInfoName*/
*startpane_scan= "-%c%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%s", 

/*  -G @ gs ps 'l'*/
*startguide_scan= "-%c%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]", 

/* -g @ % gs 'l'*/
*guidebutton_scan="-%c%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]", 

/* -Q @ % gs 'l'*/
*quitform_scan= "-%c%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]",

/* -m @ % gs 'l' 'des' v */
*subform_action_scan = "-%c%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s",

/*  -H @ gs 'l' 'des' help_path */
*help_scan= "-%c%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s", 

/* -I @ % * ! ? # gs ps 'def' 'l' 'des' v 'val' 'literal value' */
*input_scan= "-%c%d%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]",

/* -O @ % * ! ? # gs ps 'def' 'l' 'des' v 'val' 'literal value' */
*output_scan= "-%c%d%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]",

/* -i @ % * ! ? gs ps L U def 'l' 'des' v val 'literal value' */
*int_scan  ="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%d%d%d%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%d%*[ ]%*['`]%[^'`]%*['`]",

/* -f @ % * ! ? gs ps L U def 'l' 'des' v val 'literal value' */
*float_scan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%f%f%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%f%*[ ]%*['`]%[^'`]%*['`]",

/* -l @ % * ! ? gs ps def 'l' 'label0' 'label1' 'des' v val */
*logic_scan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%d%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%d",

/* -s @ % * ! ? gs ps 'def' 'l' 'des' v 'val' 'literal value' */
*string_scan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]",

/* -R @ % exec_type gs 'l' 'des' com */
*routine_scan = "-%c%d%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%[^\n]",

/*  -T @ % * ! ? gs ps def 'l' 'des' v */
*toggle_scan = "-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%d%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%d",

/* -b xpos ypos 'l' */
*blank_scan = "-%c%*[ ]+%f+%f%*[ ]%*['`]%[^'`]",

/* -a @ % gs 'l' 'des' v */
*pane_action_scan = "-%c%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s",

/* -c @ % * ! ? gs ps num def 'l' 'des' v */
*cycle_scan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%d%d%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s",

/* -x @ % * ! ? gs ps num def 'l' 'des' v */
*list_scan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%d%d%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s",

/* -p filename */
*includepane_scan = "-%c%s",

/* -k filename */
*includesubform_scan = "-%c%s",

/* -w gs ps 'l' 'des' v val */
*workspace_scan = "-%c%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%d",

/* -L library_call */
*libcall_scan = "-%c%s",

/* -A @ % gs ps 'def' 'l' 'val' 'literal value' */
*ansinfile_scan= "-%c%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]",

/* -Z @ % gs ps 'def' 'l' 'val' 'literal value' */
*ansoutfile_scan= "-%c%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]";

#endif
/* Don't add after this line */
