 /*
  * Khoros: $Id: vclose.h,v 1.2 1992/03/20 23:11:35 dkhoros Exp $
  */

 /*
  * $Log: vclose.h,v $
 * Revision 1.2  1992/03/20  23:11:35  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vclose.h
 >>>>            Author: Pascal ADAM
 >>>> Date Last Updated: Fri Feb 28 19:46:23 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vclose_h_
#define _vclose_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vclose Argument Structure
*
****************************************************************/

typedef struct _vclose  {

/*
 *  Input Boundary Image (resulting from vdrf, vgef, vsdef ...) (Required infile)
 */
char	*i1_file;	/* Input Boundary Image (resulting from vdrf, vgef, vsdef ...) FILENAME */
int	 i1_flag;	/* Input Boundary Image (resulting from vdrf, vgef, vsdef ...) FLAG */

/*
 *  Input Gradient Image (resulting from vdrf, vsdef, sobel...) (Required infile)
 */
char	*i2_file;	/* Input Gradient Image (resulting from vdrf, vsdef, sobel...) FILENAME */
int	 i2_flag;	/* Input Gradient Image (resulting from vdrf, vsdef, sobel...) FLAG */

/*
 *  resulting output image or file (Required outfile)
 */
char	*o_file;	/* resulting output image or file FILENAME */
int	 o_flag;	/* resulting output image or file FLAG */

/*
 *  Gradient Threshold (used by the closing process) (Optional integer)
 */
int	 grad_int; 	/* Gradient Threshold (used by the closing process) INT */
int	 grad_flag;	/* Gradient Threshold (used by the closing process) FLAG */

/*
 *  Minimum Gap Size In Pixels (Optional integer)
 */
int	 len_int; 	/* Minimum Gap Size In Pixels INT */
int	 len_flag;	/* Minimum Gap Size In Pixels FLAG */

}  vclose_struct;

vclose_struct *vclose;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(edge,gradient) \
edge = readimage(vclose->i1_file);  \
gradient = readimage(vclose->i2_file); \
if (edge == NULL || gradient == NULL) {  \
   (void) fprintf(stderr,"vclose: Can not read input images \n");  \
   exit(1);  /* Quit if bad image */ \
}
#define CHECKINPUT(program, edge, gradient) \
    propertype(program,edge,VFF_TYP_1_BYTE,TRUE); \
    proper_num_images(program,edge,1,TRUE);  \
    proper_num_bands(program,edge,1,TRUE);  \
    proper_map_enable(program,edge,VFF_MAP_OPTIONAL,TRUE); \
    propertype(program,gradient,VFF_TYP_1_BYTE,TRUE); \
    proper_num_images(program,gradient,1,TRUE);  \
    proper_num_bands(program,gradient,1,TRUE);  \
    proper_map_enable(program,gradient,VFF_MAP_OPTIONAL,TRUE); 
/* -include_macros_end */

#endif
