 /*
  * Khoros: $Id: v1bgamut.c,v 1.2 1991/12/18 09:29:47 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: v1bgamut.c,v 1.2 1991/12/18 09:29:47 dkhoros Exp $";
#endif

 /*
  * $Log: v1bgamut.c,v $
 * Revision 1.2  1991/12/18  09:29:47  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: v1bgamut.c
 >>>>
 >>>>      Program Name: v1bgamut
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compress grey levels of an image, produce new image with map
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Sat Nov  2 17:26:27 1991
 >>>>
 >>>>          Routines: main- the main program for v1bgamut
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "v1bgamut.h"


/****************************************************************
 *
 * Routine Name:  main program for v1bgamut
 *
 *       Input:  
 *          -i  input image filename 
 *          -o  output image filename 
 *
 *
 *          [-n] specifies the number of levels to compress to  (1 < value < 256)
 *          [-r] fraction of level splits based on 2-norm  (0.000 < value < 1.000)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        image = readimage(v1bgamut->i_file);
        if (image == NULL) exit(1);

        CHECKINPUT(program,image);
/* -main_before_lib_call_end */

/* -main_library_call */
        if(!lv1bgamut(image, v1bgamut->n_int, v1bgamut->r_float))
          {
            (void) fprintf(stderr, "lv1bgamut Failed\n");
            exit(1);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(v1bgamut->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for v1bgamut 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "v1bgamut :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompress grey levels of an image, produce new image with map\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-n]  specifies the number of levels to compress to (integer, 1 to 256) [128]\n");
	fprintf(stderr,"\t[-r]  fraction of level splits based on 2-norm (float,  0.000 to 1.000) [0.5]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for v1bgamut\n");
	fprintf(stderr, "\t[-U] Gives the usage for v1bgamut\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called v1bgamut.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses v1bgamut.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for v1bgamut
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char	*n_pstr = 
	"\nEnter: (n) specifies the number of levels to compress to \n        {integer, 1 to 256 [128] }: "; 
char	*r_pstr = 
	"\nEnter: (r) fraction of level splits based on 2-norm \n        {float,  0.000 to 1.000 [0.500000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "v1bgamut", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "v1bgamut.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "v1bgamut: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "v1bgamut.ans");
		}

	     }

	}

	/*
	 * allocate the v1bgamut structure
	 */
	v1bgamut = (v1bgamut_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (v1bgamut_struct));

	/*
	 * get required arguments for v1bgamut
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(v1bgamut->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(v1bgamut->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(v1bgamut->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    v1bgamut->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(v1bgamut->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(v1bgamut->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(v1bgamut->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(v1bgamut->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    v1bgamut->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(v1bgamut->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for v1bgamut
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	v1bgamut->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(v1bgamut->n_int),
	128, 1, 256);

	v1bgamut->r_flag = vget_float(fid, prompt_flag,
	"-r", r_pstr, &(v1bgamut->r_float),
	0.500000, 0.000000, 1.000000);


}



