 /*
  * Khoros: $Id: vbpf.c,v 1.1 1991/05/10 15:47:48 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vbpf.c,v 1.1 1991/05/10 15:47:48 khoros Exp $";
#endif

 /*
  * $Log: vbpf.c,v $
 * Revision 1.1  1991/05/10  15:47:48  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vbpf.c
 >>>>
 >>>>      Program Name: vbpf
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Perform Band-pass filtering on an  image  in  the  frequency
 >>>>	domain.
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:27:43 1991
 >>>>
 >>>>          Routines: main- the main program for vbpf
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vbpf.h"


/****************************************************************
 *
 * Routine Name:  main program for vbpf
 *
 *       Input:  
 *      -i  input image filename 
 *      -o  output image filename 
 *      -n  order of filter used   (1 < value < 6)
 *      -c  Cutoff frequency radius   (0.000 < value < 1.000)
 *      -w  bandwidth of filter   (1 < value < 2048)
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);
    image = readimage(vbpf->i_file);
    if (image == NULL) exit(1);  /* Quit if bad image */

    CHECKINPUT(program,image);  /* Verify input image */
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvbpf(image,vbpf->n_int,vbpf->c_float,vbpf->w_int))
    {
         (void) fprintf(stderr, "lvlpf Failed\n");
         exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vbpf->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vbpf 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vbpf :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerform Band-pass filtering on an  image  in  the  frequency\n");
	fprintf(stderr, "\tdomain.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr,"\t-n  order of filter used  (integer, 1 to 6)\n");
	fprintf(stderr,"\t-c  Cutoff frequency radius  (float,  0.000 to 1.000)\n");
	fprintf(stderr,"\t-w  bandwidth of filter  (integer, 1 to 2048)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vbpf\n");
	fprintf(stderr, "\t[-U] Gives the usage for vbpf\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vbpf.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vbpf.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vbpf
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char	*n_pstr = 
	"\nEnter: (n) order of filter used \n        {integer, 1 to 6}: "; 
char	*c_pstr = 
	"\nEnter: (c) Cutoff frequency radius \n        {float,  0.000 to 1.000}: "; 
char	*w_pstr = 
	"\nEnter: (w) bandwidth of filter \n        {integer, 1 to 2048}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vbpf", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vbpf.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vbpf: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vbpf.ans");
		}

	     }

	}

	/*
	 * allocate the vbpf structure
	 */
	vbpf = (vbpf_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vbpf_struct));

	/*
	 * get required arguments for vbpf
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vbpf->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vbpf->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vbpf->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vbpf->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vbpf->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vbpf->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vbpf->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vbpf->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vbpf->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vbpf->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vbpf->n_flag = vget_int(fid, prompt_flag,
			"-n", n_pstr, &(vbpf->n_int),
			1, 1, 6)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vbpf->n_flag))
		{
		    fprintf(stderr, "\t\tn is required, please re-enter: \n");
		    vbpf->n_flag = vget_int(fid, prompt_flag,
		    "-n", n_pstr, &(vbpf->n_int),
		    1, 1, 6);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-n' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vbpf->c_flag = vget_float(fid, prompt_flag,
			"-c", c_pstr, &(vbpf->c_float),
			0.500000, 0.000000, 1.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vbpf->c_flag))
		{
		    fprintf(stderr, "\t\tc is required, please re-enter: \n");
		    vbpf->c_flag = vget_float(fid, prompt_flag,
		    "-c", c_pstr, &(vbpf->c_float),
		    0.500000, 0.000000, 1.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-c' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vbpf->w_flag = vget_int(fid, prompt_flag,
			"-w", w_pstr, &(vbpf->w_int),
			10, 1, 2048)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vbpf->w_flag))
		{
		    fprintf(stderr, "\t\tw is required, please re-enter: \n");
		    vbpf->w_flag = vget_int(fid, prompt_flag,
		    "-w", w_pstr, &(vbpf->w_int),
		    10, 1, 2048);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-w' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



