 /*
  * Khoros: $Id: vpml.h,v 1.1 1991/05/10 15:47:27 khoros Exp $
  */

 /*
  * $Log: vpml.h,v $
 * Revision 1.1  1991/05/10  15:47:27  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vpml.h
 >>>>            Author: Charlie Gage
 >>>> Date Last Updated: Tue Mar  5 22:26:51 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vpml_h_
#define _vpml_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vpml Argument Structure
*
****************************************************************/

typedef struct _vpml  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  resulting multiband fractal dimension output image (Required outfile)
 */
char	*o1_file;	/* resulting multiband fractal dimension output image FILENAME */
int	 o1_flag;	/* resulting multiband fractal dimension output image FLAG */

/*
 *  output image specifying the fractal dimension of each class (Required outfile)
 */
char	*o2_file;	/* output image specifying the fractal dimension of each class FILENAME */
int	 o2_flag;	/* output image specifying the fractal dimension of each class FLAG */

/*
 *  output file for P(m,L) statistics (Optional outfile)
 */
char	*f1_file;	/* output file for P(m,L) statistics FILENAME */
int	 f1_flag;	/* output file for P(m,L) statistics FLAG */

/*
 *  select the initial size of the sliding window (Optional integer)
 */
int	 l_int; 	/* select the initial size of the sliding window INT */
int	 l_flag;	/* select the initial size of the sliding window FLAG */

/*
 *  select the final size of the sliding window (Optional integer)
 */
int	 u_int; 	/* select the final size of the sliding window INT */
int	 u_flag;	/* select the final size of the sliding window FLAG */

/*
 *  select the window step size or interval (Optional integer)
 */
int	 s_int; 	/* select the window step size or interval INT */
int	 s_flag;	/* select the window step size or interval FLAG */

/*
 *  select the range of moments (-r/2 <= 0 >= r/2) (Optional integer)
 */
int	 q_int; 	/* select the range of moments (-r/2 <= 0 >= r/2) INT */
int	 q_flag;	/* select the range of moments (-r/2 <= 0 >= r/2) FLAG */

}  vpml_struct;

vpml_struct *vpml;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
    image = readimage(vpml->i_file); \
    if(image == NULL){ \
        (void) fprintf(stderr,"vpml: Image could not be read\\n"); \
        exit(1); \
    }

#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); \
/* -include_macros_end */

#endif
