 /*
  * Khoros: $Id: vfractal.h,v 1.1 1991/05/10 15:47:21 khoros Exp $
  */

 /*
  * $Log: vfractal.h,v $
 * Revision 1.1  1991/05/10  15:47:21  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vfractal.h
 >>>>            Author: Charlie Gage
 >>>> Date Last Updated: Tue Mar  5 22:26:22 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vfractal_h_
#define _vfractal_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vfractal Argument Structure
*
****************************************************************/

typedef struct _vfractal  {

/*
 *  input image filename (Required infile)
 */
char	*i_file;	/* input image filename FILENAME */
int	 i_flag;	/* input image filename FLAG */

/*
 *  output image filename (Required outfile)
 */
char	*o_file;	/* output image filename FILENAME */
int	 o_flag;	/* output image filename FLAG */

/*
 *  region size argument (Optional integer)
 */
int	 r_int; 	/* region size argument INT */
int	 r_flag;	/* region size argument FLAG */

/*
 *  initial window size argument (Optional integer)
 */
int	 w_int; 	/* initial window size argument INT */
int	 w_flag;	/* initial window size argument FLAG */

/*
 *  step size argument (Optional integer)
 */
int	 s_int; 	/* step size argument INT */
int	 s_flag;	/* step size argument FLAG */

}  vfractal_struct;

vfractal_struct *vfractal;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
    image = readimage(vfractal->i_file); \
    if(image == NULL){ \
        (void) fprintf(stderr,"vfractal: Image could not be read\\n"); \
        exit(1); \
    }

#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
