 /*
  * Khoros: $Id: vblend.c,v 1.1 1991/05/10 15:45:09 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vblend.c,v 1.1 1991/05/10 15:45:09 khoros Exp $";
#endif

 /*
  * $Log: vblend.c,v $
 * Revision 1.1  1991/05/10  15:45:09  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vblend.c
 >>>>
 >>>>      Program Name: vblend
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Blend two images using  X*image1 + (1-X)*image2  where X  is
 >>>>	the blend ratio.
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:50:31 1991
 >>>>
 >>>>          Routines: main- the main program for vblend
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vblend.h"


/****************************************************************
 *
 * Routine Name:  main program for vblend
 *
 *       Input:  
 *        -i1  input image 1 
 *        -i2  input image 2 
 *        -o  resulting output image 
 *
 *
 *
 *        [-m  blend mask image   -OR-
 *         -x  Blending ratio    (0.000 < value < 1.000)) ]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
   struct xvimage *img1,*img2,*img3,*images[2],*readimage();
   int  num_images, up_type;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    num_images = 0;        /* initialize image counter */

    img1 = readimage(vblend->i1_file);
    if (img1 == NULL)
      {
        fprintf(stderr,"vblend: unable to read input image\n");
        exit(1);                   /* Quit if bad image */
      }
    images[num_images++] = img1;

    img2 = readimage(vblend->i2_file);
    if (img2 == NULL)
      {
        fprintf(stderr,"vblend: unable to read input image\n");
        exit(1);                   /* Quit if bad image */
      }
    images[num_images++] = img2;

    if (vblend->m_flag)
      {
        img3 = readimage(vblend->m_file);
        if (img3 == NULL)
          {
            fprintf(stderr,"vblend: unable to read blend mask image\n");
            exit(1);                   /* Quit if bad image */
          }
      }

    CHECKINPUT(program,img1,img2);      /* Verify input images */

    if (vblend->m_flag)            /* check input mask image */
      {
        if (img3->data_storage_type != VFF_TYP_FLOAT)
          {
                 /* If mask image not FLOAT, then convert it to FLOAT */
            if (!lvconvert(img3, 5, 0, 1, 0.0, 1.0))
            {
               (void) fprintf(stderr,"ERROR: lvconvert failed\n");
               exit(1);
            }
          }
        if (img3->row_size != img1->row_size ||
            img3->col_size != img1->col_size)
          {
            fprintf(stderr,"vblend: blend mask must have same number of rows and cols as input images\n");
            exit(1);
          }
      }

    up_type = -1;      /* call lvcast with auto upconvert set */

                       /*  Call lvcast to upconvert data types */
    if (! lvcast(images, num_images, up_type) )
    {
       (void) fprintf(stderr, "ERROR: images could not be cast to the same type\n");
       exit(1);
    }
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvblend(img1,img2,img3,vblend->x_float,vblend->m_flag))
    {
        (void) fprintf(stderr, "lvblend Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    (void) writeimage(vblend->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vblend 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vblend :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tBlend two images using  X*image1 + (1-X)*image2  where X  is\n");
	fprintf(stderr, "\tthe blend ratio.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input image 1  (infile)\n");
	fprintf(stderr,"\t-i2  input image 2  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\t[ ");
	fprintf(stderr,"-m  blend mask image  (infile) -OR- \n");
	fprintf(stderr,"\t  -x  Blending ratio  (float,  0.000 to 1.000) ]\n\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vblend\n");
	fprintf(stderr, "\t[-U] Gives the usage for vblend\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vblend.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vblend.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vblend
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input image 1 \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input image 2 \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*m_pstr = 
	"\nEnter: (m) blend mask image \n        {infile}: "; 
char	*x_pstr = 
	"\nEnter: (x) Blending ratio \n        {float,  0.000 to 1.000 [0.500000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vblend", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vblend.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vblend: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vblend.ans");
		}

	     }

	}

	/*
	 * allocate the vblend structure
	 */
	vblend = (vblend_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vblend_struct));

	/*
	 * get required arguments for vblend
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vblend->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vblend->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vblend->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vblend->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vblend->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vblend->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vblend->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vblend->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vblend->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vblend->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vblend->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vblend->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vblend->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vblend->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vblend->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional mutually exclusive groups for vblend
	 */
	if (prompt_flag == TRUE)
	{
		   fprintf(stderr, "\nThe following prompts are mutually exclusive.\n");
		   fprintf(stderr, "\nHit <cr> until the desired prompt appears.\n");
		vblend->m_flag = vget_infile(fid, prompt_flag,
		    "-m", m_pstr, &(vblend->m_file))
;

    		if(!( (vblend->m_flag)))
		    vblend->x_flag = vget_float(fid, prompt_flag,
		    "-x", x_pstr, &(vblend->x_float),
		    0.500000, 0.000000, 1.000000);

		   fprintf(stderr, "\n ------\n");
	}
	else
	{
		count = 0;
		if(vblend->m_flag = vget_infile(fid, prompt_flag,
		    "-m", m_pstr, &(vblend->m_file))
)
		    count++;

		if(vblend->x_flag = vget_float(fid, prompt_flag,
		    "-x", x_pstr, &(vblend->x_float),
		    0.500000, 0.000000, 1.000000))
		    count++;

		if (count > 1)
		{
		    fprintf(stderr, "Error: You may specify ONLY ONE of :\n");
		    fprintf(stderr, " -m  -x \n");
		    gw_usage();
		    exit(1);
		}

	}


}



