 /*
  * Khoros: $Id: lvgrad.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvgrad.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvgrad.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvgrad.c
 >>>>
 >>>>      Program Name: vgrad
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:29:27 1991 
 >>>>
 >>>>          Routines: lvgrad - the library call for vgrad
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvgrad - library call for vgrad
*
* Purpose:
*    
*    Sharpens an image by differentiation (gradient).
*    
*    
* Input:
*    
*         1. img -- xvimage structure
*         2. procedure -- type of procedure to perform
*                         the gradient
*                         type=1 uses horizontal and
*                                vertical differences (def.)
*                         type=2 Roberts gradient
*                                (uses cross-differences)
*         3. pneg -- invert image argument,
*                    if 0 photopositive (default)
*                    is active, if 1 photonegative
*                    is active
*    
*    
* Output:
*    
*         1. img -- xvimage structure, holds the
*                   differentiated image
*    
*         img is used for both the input  xvimage  structure  and  the
*         output  result  xvimage  structure.   This  is  done to save
*         space, but you must be careful not  to  overwrite  important
*         data.
*    
*    
*
* Written By: Marcelo Teran, Ramiro Jordan
*    
*    
****************************************************************/


/* -library_def */
int
lvgrad(img,procedure,pneg)
struct xvimage *img;
int  procedure, pneg;
/* -library_def_end */

/* -library_code */
{

    int row,                            /* points image row */ 
        col,                            /* points image col */ 
        xend,                           /* step in img up to here */
        yend,                           /* step in img up to here */
        nc,                             /* column size of image */
        nr,                             /* row size of image */
        index,
        horz,
        vert;

    unsigned char *ptr,                 /* pointer to the image data char */
                  *result;              /* pointer to resulting image char */

    char  *program;                     /* contains the library name */

    program = "lvgrad";

    propertype(program,img,VFF_TYP_1_BYTE,1);      /* check img. type */        

    nr = img->col_size;
    nc = img->row_size;

    xend = nc - 1;
    yend = nr - 1;

   /* Allocate space for resulting image */ 
    result = (unsigned char *)malloc((unsigned int)nc*nr*sizeof(unsigned char));
    if(result == NULL) {
        (void) fprintf(stderr,"lvgrad: insufficient memory available\n");
        return(0);
    }
   
   /* Zero array for result */
    bzero((char *) result, (int) nc*nr * sizeof(unsigned char));

   /* Assign image data address to ptr */
    ptr = (unsigned char *)img->imagedata;

    switch(procedure){
        case 0:

               /* perform sobel process */
                for (row = 0 ; row < yend; row++){
                    for (col = 0 ; col < xend; col++){

                       /* take gradients */
                        index = row * nc + col;
                        horz = ptr[index] - ptr[index + 1]; 
                        if(horz < 0) horz *= -1;
                        vert = ptr[index] - ptr[index + nc]; 
                        if(vert < 0) vert *= -1;

                       /* assign the value to respective place */
                        result[index] = horz + vert;
                    }
                }
                break;

        case 1:

               /* perform sobel process */
                for (row = 0 ; row < yend; row++){
                    for (col = 0 ; col < xend; col++){

                       /* take gradients */
                        index = row * nc + col;
                        horz = ptr[index] - ptr[index + nc + 1]; 
                        if(horz < 0) horz *= -1;
                        vert = ptr[index + nc] - ptr[index + 1]; 
                        if(vert < 0) vert *= -1;

                       /* assign the value to respective place */
                        result[index] = horz + vert;
                    }
                }
                break;
    }

    free (img->imagedata);
    img->imagedata = (char *) result;

    if(pneg)
    {
        if( !lvinvert(img) )
        {
            (void) fprintf(stderr,"lvinvert Failed\n");
            return(0);
        }
    }

    return(1);
}
/* -library_code_end */
