 /*
  * Khoros: $Id: asc2viff.h,v 1.1 1991/05/10 15:52:29 khoros Exp $
  */

 /*
  * $Log: asc2viff.h,v $
 * Revision 1.1  1991/05/10  15:52:29  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: asc2viff.h
 >>>>            Author: Ramiro Jordan, Mike Lang, Mark Young
 >>>> Date Last Updated: Wed Mar 27 18:34:10 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _asc2viff_h_
#define _asc2viff_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    asc2viff Argument Structure
*
****************************************************************/

typedef struct _asc2viff  {

/*
 *  input ascii data file (Required infile)
 */
char	*i_file;	/* input ascii data file FILENAME */
int	 i_flag;	/* input ascii data file FLAG */

/*
 *  resulting output image (viff file) (Required outfile)
 */
char	*o_file;	/* resulting output image (viff file) FILENAME */
int	 o_flag;	/* resulting output image (viff file) FLAG */

/*
 *  number of rows (Required integer)
 */
int	 r_int; 	/* number of rows INT */
int	 r_flag;	/* number of rows FLAG */

/*
 *  number of columns (Required integer)
 */
int	 c_int; 	/* number of columns INT */
int	 c_flag;	/* number of columns FLAG */

/*
 *  if yes the ascii input file is supposed to be interleaved; if no (default) it is considered as not interleaved (Optional logical)
 */
int	 fi_logic;	/* if yes the ascii input file is supposed to be interleaved; if no (default) it is considered as not interleaved LOGIC */
int	 fi_flag;  	/* if yes the ascii input file is supposed to be interleaved; if no (default) it is considered as not interleaved FLAG */

/*
 *  if no (default), the data are supposed real, if yes, the data should be defined as a complex pair in the ascii file (Optional logical)
 */
int	 t_logic;	/* if no (default), the data are supposed real, if yes, the data should be defined as a complex pair in the ascii file LOGIC */
int	 t_flag;  	/* if no (default), the data are supposed real, if yes, the data should be defined as a complex pair in the ascii file FLAG */

/*
 *  increment factor for skipping rows (Optional integer)
 */
int	 m_int; 	/* increment factor for skipping rows INT */
int	 m_flag;	/* increment factor for skipping rows FLAG */

/*
 *  increment factor for skipping columns (Optional integer)
 */
int	 n_int; 	/* increment factor for skipping columns INT */
int	 n_flag;	/* increment factor for skipping columns FLAG */

/*
 *  specify the number of data bands (image) (Optional integer)
 */
int	 b_int; 	/* specify the number of data bands (image) INT */
int	 b_flag;	/* specify the number of data bands (image) FLAG */

/*
 *  specify the number of location bands (dimensions) (Optional integer)
 */
int	 d_int; 	/* specify the number of location bands (dimensions) INT */
int	 d_flag;	/* specify the number of location bands (dimensions) FLAG */

/*
 *  number of points to offset from the start of the data file (Optional integer)
 */
int	 h_int; 	/* number of points to offset from the start of the data file INT */
int	 h_flag;	/* number of points to offset from the start of the data file FLAG */

/*
 *  number of points to offset from the first point of each band (Optional integer)
 */
int	 s_int; 	/* number of points to offset from the first point of each band INT */
int	 s_flag;	/* number of points to offset from the first point of each band FLAG */

}  asc2viff_struct;

asc2viff_struct *asc2viff;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
