 /*
  * Khoros: $Id: dextract.c,v 1.2 1992/03/20 23:33:45 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dextract.c,v 1.2 1992/03/20 23:33:45 dkhoros Exp $";
#endif

 /*
  * $Log: dextract.c,v $
 * Revision 1.2  1992/03/20  23:33:45  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dextract.c
 >>>>
 >>>>      Program Name: dextract
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Extracts 1-D Subsignal(s)
 >>>>	
 >>>>	

 >>>>            Author: Donna Koechner
 >>>>
 >>>> Date Last Updated: Wed Feb 19 09:00:07 1992
 >>>>
 >>>>          Routines: main- the main program for dextract
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dextract.h"


/****************************************************************
 *
 * Routine Name:  main program for dextract
 *
 *       Input:  
 *          -i  input image 
 *          -o  resulting output image 
 *
 *
 *          [-x] Starting point for data subset  (value >= 0)
 *          [-d] data processing direction (0 = down vectors, 1 = across bands)
 *
 *          [-e  Extract rest of file   -OR-
 *           -l  Specify length    (value > 0)) ]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}

READINPUT(image);
CHECKTYPE(program, image) ;
CHECKINPUT(program, image) ;

 /*
  * If neither length option (-e or -l) was specified, set default of
  * extracting rest of file.
  */
  if ( (!dextract->e_flag) && (!dextract->l_flag) )
  {
    dextract->e_logic = TRUE;
  }

 /* 
  * If only -l is specified, set e_logic to false
  */
  if ( dextract->l_flag && (!dextract->e_flag) )
  {
    dextract->e_logic = FALSE;
  }

/* -main_before_lib_call_end */

/* -main_library_call */
  if (!(ldextract(image,                  
                   dextract->x_int,        /* first point */
                   dextract->e_logic,      /* extract to end of sequence */
                   dextract->l_int,        /* specified length of sequence */
                   dextract->d_logic) ))  /* process direction */
  {
    (void) fprintf(stderr, "ldextract Failed\\n");
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
(void) writeimage(dextract->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dextract 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dextract :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tExtracts 1-D Subsignal(s)\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-x]  Starting point for data subset (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\t[ ");
	fprintf(stderr,"-e  Extract rest of file  (boolean) -OR- \n");
	fprintf(stderr,"\t  -l  Specify length  (integer, > 0) ]\n\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dextract\n");
	fprintf(stderr, "\t[-U] Gives the usage for dextract\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dextract.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dextract.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dextract
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*x_pstr = 
	"\nEnter: (x) Starting point for data subset \n        {integer, >= 0 [0] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*e_pstr = 
	"\nEnter: (e) Extract rest of file \n        {boolean, (y/n)  [yes] }: "; 
char	*l_pstr = 
	"\nEnter: (l) Specify length \n        {integer, > 0 [1] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dextract", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dextract.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dextract: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dextract.ans");
		}

	     }

	}

	/*
	 * allocate the dextract structure
	 */
	dextract = (dextract_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dextract_struct));

	/*
	 * get required arguments for dextract
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dextract->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dextract->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dextract->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dextract->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dextract->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dextract->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dextract->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dextract->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dextract->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dextract->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dextract
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dextract->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(dextract->x_int),
	0, 1, 1);

	dextract->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dextract->d_logic), 1);

	/*
	 * get optional mutually exclusive groups for dextract
	 */
	if (prompt_flag == TRUE)
	{
		   fprintf(stderr, "\nThe following prompts are mutually exclusive.\n");
		   fprintf(stderr, "\nHit <cr> until the desired prompt appears.\n");
		dextract->e_flag = vget_logic(fid, prompt_flag,
		    "-e", e_pstr, &(dextract->e_logic), 1);

    		if(!( (dextract->e_flag)))
		    dextract->l_flag = vget_int(fid, prompt_flag,
		    "-l", l_pstr, &(dextract->l_int),
		    1, 2, 2);

		   fprintf(stderr, "\n ------\n");
	}
	else
	{
		count = 0;
		if(dextract->e_flag = vget_logic(fid, prompt_flag,
		    "-e", e_pstr, &(dextract->e_logic), 1))
		    count++;

		if(dextract->l_flag = vget_int(fid, prompt_flag,
		    "-l", l_pstr, &(dextract->l_int),
		    1, 2, 2))
		    count++;

		if (count > 1)
		{
		    fprintf(stderr, "Error: You may specify ONLY ONE of :\n");
		    fprintf(stderr, " -e  -l \n");
		    gw_usage();
		    exit(1);
		}

	}


}



