 /*
  * Khoros: $Id: ApolloRPC.h,v 1.3 1992/03/20 23:37:33 dkhoros Exp $
  */

 /*
  * $Log: ApolloRPC.h,v $
 * Revision 1.3  1992/03/20  23:37:33  dkhoros
 * VirtualPatch5
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>								<<<<
   >>>>	    file name: ApolloRPC.h				<<<<
   >>>>								<<<<
   >>>>   description:						<<<<
   >>>>								<<<<
   >>>> modifications:						<<<<
   >>>>								<<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _ApolloRPC_h_
#define _ApolloRPC_h_

/* Apollo's remote procedure transport */


/*
 *  Internal structures for the following transport
 *
 *		apollorpc	   -  Apollo's remote procedure transport
 */

/* apollorpc structure */
typedef struct
{
	int dummy;
} ApollorpcStruct;

#undef  ResourceStruct
#define ResourceStruct ApollorpcStruct

int	apollorpc_tempnam(),
	apollorpc_open(),
	apollorpc_close(),
	apollorpc_read(),
	apollorpc_write(),
	apollorpc_lseek(),
	apollorpc_tell(),
	apollorpc_unlink(),
	apollorpc_exec(),
	apollorpc_machtype(),
	apollorpc_gethostname();

static RemoteInformation remote_apollorpc_routines[] =
{
    {
	apollorpc_exec,
	apollorpc_machtype,
	apollorpc_gethostname,
    }
};

static TransportInformation apollorpc_routines[] =
{
    {
	"Apollo's Remote Procedure Call",
	"apollorpc",
	FALSE,
	apollorpc_tempnam,
	apollorpc_open,
	apollorpc_close,
	apollorpc_read,
	apollorpc_write,
	apollorpc_lseek,
	apollorpc_tell,
	NULL,
	apollorpc_unlink,
	NULL,
	NULL,

	remote_apollorpc_routines,
    }
};

#endif /* _ApolloRPC_h_ */
/* don`t add after the endif */
