 /*
  * Khoros: $Id: vpoly.h,v 1.3 1992/03/20 22:35:15 dkhoros Exp $
  */

 /*
  * $Log: vpoly.h,v $
 * Revision 1.3  1992/03/20  22:35:15  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: vpoly.h                                <<<<
   >>>>                                                       <<<<
   >>>>   description: defines and structures used by the     <<<<
   >>>>		       polynomial parser found in vmath.a     <<<<
   >>>>		       and any routines that use the parser   <<<<
   >>>>		       or its utilities: readpoly(),          <<<<
   >>>>		       writepoly(), and createpoly()	      <<<<
   >>>>                                                       <<<<
   >>>>      routines: none whatsoever in this file	      <<<<
   >>>>                                                       <<<<
   >>>> modifications: J. Rasure Sun Sep 30 22:15:28 MDT 1990 <<<<
   >>>>				added ifdefs so that things   <<<<
   >>>>				won't be accidently multiply  <<<<
   >>>>				defined.		      <<<<
   >>>>                                                       <<<<
   >>>>		       J. Worley Mon Nov 26 09:38:48 MST 1990 <<<<
   >>>>				modified the structures so    <<<<
   >>>>				that the poly structure       <<<<
   >>>>				contains a term array that    <<<<
   >>>>				holds term definitions.  The  <<<<
   >>>>				term def can handle simple    <<<<
   >>>>				function terms, i.e. f(n) or  <<<<
   >>>>				f(n-3), or 3.0*f(n-3). Also   <<<<
   >>>>				#defined the string length,   <<<<
   >>>>				which should have been done   <<<<
   >>>>				in the first place.	      <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _vpoly_h_
#define _vpoly_h_

#define _STRLENGTH 32
#define _FUNCTION  1
#define _STDTERM   0
#define _ADJSIZE   10 

/*
** function return values for poly_func_type function
*/

#define POLY_MIXED 0
#define POLY_NORM  1
#define POLY_DIFF  2

/*
** structure used by poly_parse()
*/

struct polystack {
   int type;
   float value;
   float order;
   char   string[_STRLENGTH];
   char   fname[_STRLENGTH];
   struct polystack *next;
} ;

struct term_struct {
   int   type;		/* 0 = ordinary term, 1 = function term */
   float coef;		/* value of coefficient */
   float expon;		/* value of exponent */
   int   delay;		/* delay if its a function */
   char  *varname;	/* name of variable */
   char  *fname;	/* function term */
} term_struct;

struct poly_struct {
   int sdim,tdim;
   int stages;		/* number of stages in polynomial */
   int *nterms;		/* pair that indicates number of terms per stage */
   struct term_struct *terms;	/* array of terms */
   char *indep_var;	/* name of independant variable */
   char *func_name;	/* name of function */
} poly_struct;

#define SPTR_MAX 100
#define YYSTYPE struct polystack

/*
 * definition for poly_malloc().  Added by Mark since malloc's on cray
 * were failing due to the fact that malloc(0) was being requested.
 */

char *poly_malloc();

#endif /* _vpoly_h_ */
/* Don't add after the endif */
