/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/

/*************************************************************
*
*  File:  noproto.h
*
*  Purpose: function declarations for systems that
*           don't take ANSI prototypes.
*/

void set_f_phase_density();
void set_e_phase_density();
void sp_order();
int  sp_fill_setup();
void sp_factor();
void sp_backsub();
void stability_test();
void mobility_cleanup();
void mobility_mult();
void mobility_setup();
void approx_curv_calc();
void approx_curvature();
void phase_initialize();
void check_vertex_fe();
int new_popverst();
void information();
void show_volumes();
void set_parameters();
void string_fixup();
char *kb_realloc();
void runge_kutta();
void autopop_pop();
void autochop_chop();
void autopop_detect();
vertex_id find_other_vertex();
void simplex_delauney_test();
void push_face();
int pop_face();
void end_face_stack();
void init_face_stack();
void simplex_equiangulate();
int kernel_basis();
void tr_mat_mul();
void mat_mul_tr();
void calc_simplex_edge_energy();
void exterior_product();
int binom_coeff();
void hi_dim_graph();
void recalc();
void kusner_energy();
void sqgauss_energy();
void kusner_force();
void prompt();
void newton_ysmp();
void set_spinr();
void set_spinl();
void set_tipup();
void set_tipdown();
void set_clockwise();
void set_counterclockwise();
void skinny_histogram();
int skinny();
int get_edge_valence();
void alice();
void sqcurve_force_string_end();
void sqcurve_force_string();
void sqcurve_energy_string();
void sqcurve_force_init();
void sqcurve_energy_init();
void sqcurve_energy(); 
void sqcurve_force(); 
void sqcurve_energy_end();
void sqcurve_force_end();
void top_dump();
void vertex_dump();
void edge_dump();
void facet_dump();
void facetedge_dump();
void body_dump();
WRAPTYPE torus_inverse();
WRAPTYPE torus_compose();
void torus_wrap();
void torus_form_pullback();
WRAPTYPE group_inverse();
WRAPTYPE group_compose();
void group_wrap();
void group_form_pullback();
void print_matrix();
double simplex_energy_metric();
void simplex_force_metric();
void gauss_setup();
double quadratic_form();
void vec_mat_mul();
void check_orientation();
void end_hash_table();
void refine_query();
void set_query();
void list_query();
void delete_query();
int poponest();
void free_discards();
int find_vertex_to_pop();
void puff();
double splinepoly();
double splinederiv();
void spline_partial();
void spline_partial_t();
int  command();
void newcommand();
void new_history();
void old_history();
char *mycalloc();
char *temp_calloc();
void temp_free();
void temp_free_all();
void cg_direction();
void cg_calc_gamma();
void facet_average();
void simplex_facet_average();
void edge_average();
void recalc_verts();
void grule();
void read_facet_edges();
void read_faces();
void read_edges();
void read_vertices();
void read_bodies();
void read_quantity();
void End_OOGL();
void UpdateOOGL();
void Begin_OOGL();
void softimage();
void constraint_init();
void constraint_free();
REAL find_flux();
void expr_convert();
void startup();
/*global*/  void read_surface_energy();
void read_parameter();
void zoom_vertex();
REAL distance();
int collapse_check();
void merge_collapsed_facets();
void homothety();
void ex_fold();
void fold_recur();
void unput();
int  yylex();
int yybegin();
void yylex_init();
int  macro();
void record_macro();
int gettoken();
void fe_reorder();
void pix_start();
void pix_facet();
void pix_end();
void constr_edge_force_q();
void move_vertex();
void restore_vertex();
REAL normal_change_check();
FILE *path_open();
char *getenv();
void fil_finish();
void fil_facet();
void fil_edge();
void fil_init();
void ps_finish();
void ps_facet();
void ps_edge();
void ps_init();
void display_file();
void graph_help();
void main_help();
REAL edge_grav_density();
int facetedge_check();
int facet_body_check();
int list_check();
int run_checks();
void pop_vertex();
int popfilm();
void face_triangulate();
void file_wulff();
void lens_wulff();
void hemi_wulff();
int curtest_facet();
int curtest_facet();
int curtest_edge();
void curtest();
void fix_volconst();
element_id upgrade();
facet_id dup_facet();
body_id dup_body();
double estimate_decrease();
void constr_edge_content_q();
void constr_edge_energy_q();
void tordup();
void add_outside();
void calc_content();
int equal_constr() ;
void      bdry_spring_energy();
void      constr_spring_energy();
int boundary_pull_film();
void torus_cells();
void torus_edge_clip();                 
void null_function();
void diffuse();
int cone_analyze();
vertex_id dup_vertex();
edge_id dup_edge();
void versplit() ;
int try_prop();
int edgepop_film();
void exprint_recur();
char *kb_strstr();
void kb_memmove();
void  constr_springs();
void save_coords();
void restore_coords();
void unsave_coords();
/*global*/  void b_proj();
/*global*/  void b_extrapolate();
/*global*/  void bdry_force();
/*global*/  void calc_bdry_force_v();
/*global*/  void calc_bdry_force_e();
/*global*/  void calc_bdry_energy_v();
/*global*/  void calc_bdry_energy_e();
/*global*/  void calc_bdry_content_v();
/*global*/  void calc_bdry_content_e();
/*global*/  void calc_force();
/*global*/  void calc_energy();
/*global*/  void calc_pressure();
/*global*/  void reset_mode();
/*global*/  void cgigraph_edge();
/*global*/  void cgigraph_facet();
/*global*/  void close_graphics();
/*global*/  void display();
/*global*/  int  constr_proj();
/*global*/  void project_v_constr();
/*global*/  void calc_constr_force_v();
/*global*/  void calc_constr_force_e();
/*global*/  void calc_constr_energy_v();
/*global*/  void calc_constr_energy_e();
/*global*/  void calc_constr_content_v();
/*global*/  void calc_constr_content_e();
/*global*/  void dump();
/*global*/  void do_dump();
/*global*/  REAL eval();
/*global*/  void eval_all();
/*global*/  REAL tree_eval();
/*global*/  REAL eval_deriv();
/*global*/  REAL tree_eval_deriv();
/*global*/  int exparse();
/*global*/  void calc_simplex_forces();
/*global*/  void calc_simplex_energy();
/*global*/  void calc_simplex_volume();
/*global*/  void facet_force_l();
/*global*/  void facet_energy_l();
/*global*/  void facet_force_l_hi_d();
/*global*/  void facet_energy_l_hi_d();
/*global*/  void facet_volume_l();
/*global*/  void film_grad_l();
/*global*/  void film_bdry_grad();
/*global*/  void film_constr_grad();
/*global*/  void facet_force_q();
/*global*/  void facet_energy_q();
/*global*/  void facet_volume_q();
/*global*/  void film_grad_q();
/*global*/  REAL tq7_integral();
/*global*/  REAL intpoly6();
/*global*/  REAL intpoly6part();
/*global*/  REAL vintzf();
/*global*/  void vcoeff_init();
/*global*/  void vol_project();
/*global*/  int graphgen();
/*global*/  void plain_facets();
/*global*/  void bare_edges();
/*global*/  void triple_edges();
/*global*/  void plain_edges();
/*global*/  void torus_clip();
/*global*/  int bfcomp();
/*global*/  void torus_bodies();
/*global*/  void reset_web();
/*global*/  void initialize();
/*global*/  void read_periods();
/*global*/  void wulff_initialize();
/*global*/  void read_boundary();
/*global*/  void read_constraint();
/*global*/  void iterate();
/*global*/  void fix_vertices();
/*global*/  void move_vertices();
/*global*/  void jiggle();
/*global*/  void long_jiggle();
/*global*/  REAL gaussian();
/*global*/  void nrerror();
/*global*/  void matcopy();
/*global*/  REAL * *dmatrix();
/*global*/  REAL * * *dmatrix3();
/*global*/  int *ivector();
/*global*/  REAL *vector();
/*global*/  void free_ivector();
/*global*/  void free_vector();
/*global*/  void free_matrix();
/*global*/  void free_matrix3();
/*global*/  void vnormal();
/*global*/  void cross_prod();
/*global*/  REAL triple_prod();
/*global*/  REAL dot();
/*global*/  REAL dotf();
/*global*/  void matvec_mul();
/*global*/  void mat_mult();
/*global*/  int  mat_inv();
/*global*/  double  determinant();
/*global*/  double  det_adjoint();
/*global*/  void change_model();
/*global*/  void linear_to_quad();
/*global*/  void quad_to_linear();
/*global*/  void edge_divide();
/*global*/  void cross_cut();
/*global*/  void display();
/*global*/  void painter_start();
/*global*/  void painter_facet();
/*global*/  void painter_end();
/*global*/  int in_back();
/*global*/  void pivot();
/*global*/  void painter_edge();
/*global*/  int verpop_film();
/*global*/  void do_save();
/*global*/  void do_restore();
/*global*/  void set_attr();
/*global*/  void unset_attr();
/*global*/  void set_fe_edge();
/*global*/  void set_fe_facet();
/*global*/  long get_fe_facet();
/*global*/  long get_prev_facet();
/*global*/  long get_next_facet();
/*global*/  void set_prev_edge();
/*global*/  void set_next_edge();
/*global*/  void set_prev_facet();
/*global*/  void set_next_facet();
/*global*/  void set_edge_wrap();
/*global*/  WRAPTYPE get_edge_wrap();
/*global*/  void set_edge_fe();
/*global*/  long get_edge_fe();
/*global*/  void set_edge_tailv();
/*global*/  void set_edge_headv();
/*global*/  long get_facet_body();
/*global*/  void set_facet_body();
/*global*/  long get_facet_fe();
/*global*/  void set_facet_fe();
/*global*/  long new_vertex();
/*global*/  long new_edge();
/*global*/  long new_facet();
/*global*/  long new_body();
/*global*/  long new_facetedge();
/*global*/  REAL get_edge_length();
/*global*/  REAL get_facet_pressure();
/*global*/  void generate_facet_fe_init();
/*global*/  int generate_facet_fe();
/*global*/  void generate_edge_fe_init();
/*global*/  int generate_edge_fe();
/*global*/  struct element *elptr();
/*global*/  void extend();
/*global*/  long new_element();
/*global*/  void free_element();
/*global*/  int ordinal();
/*global*/  int generate_all();
/*global*/  void memory_report();
/*global*/  void reset_skeleton();
/*global*/  void vgrad_init();
/*global*/  void vgrad_end();
/*global*/  struct volgrad *get_vertex_vgrad();
/*global*/  struct volgrad *get_next_vgrad();
/*global*/  struct volgrad *new_vgrad();
/*global*/  struct volgrad *get_bv_vgrad();
/*global*/  struct volgrad *get_bv_new_vgrad();
/*global*/  struct element *elptr();
/*global*/  void extend();
/*global*/  long new_element();
/*global*/  void free_element();
/*global*/  int generate_all();
/*global*/  void memory_report();
/*global*/  void reset_skeleton();
/*global*/  struct volgrad *get_next_vgrad();
/*global*/  struct volgrad *new_vgrad();
/*global*/  struct volgrad *get_bv_vgrad();
/*global*/  struct volgrad *get_bv_new_vgrad();
/*global*/  void edge_force_l();
/*global*/  void edge_energy_l();
/*global*/  void edge_area_l();
/*global*/  void edge_force_l_metric();
/*global*/  void edge_energy_l_metric();
/*global*/  void edge_force_q_metric();
/*global*/  void edge_energy_q_metric();
/*global*/  void string_grad_l();
/*global*/  void string_bdry_grad();
/*global*/  void string_constr_grad();
/*global*/  REAL interpoly();
/*global*/  REAL interpolyderiv();
/*global*/  void scoeff_init();
/*global*/  void edge_force_q();
/*global*/  void edge_energy_q();
/*global*/  void edge_area_q();
/*global*/  void string_grad_q();
/*global*/  int main();
/*global*/  void torshow();
/*global*/  int  view_transform();
/*global*/  void init_view();
/*global*/  void resize();
/*global*/  void old_menu();
/*global*/  void extrapolate();
/*global*/  void save();
/*global*/  void restore();
/*global*/  void torvol();
/*global*/  void torvol_project();
/*global*/  void refine();
/*global*/  int areaweed();
/*global*/  void area_histogram();
/*global*/  int edgeweed();
/*global*/  void edge_histogram();
/*global*/  int eliminate_edge();
/*global*/  void change_vertex();
/*global*/  int articulate();
/*global*/  int edge_refine();
/*global*/  int equiangulate();
/*global*/  int ridge_notcher();
/*global*/  void outstring();
/*global*/  void getstring();
/*global*/  void error();
/*global*/  void catcher();
/*global*/  void calc_edge();
/*global*/  void get_edge_side();
/*global*/  void get_adjust();
/*global*/  void get_edge_adjust();
/*global*/  void calc_vertex_normal();
/*global*/  void get_facet_verts();
/*global*/  int verpop_str();
void dump_force();
void vertex_average();
void global_adjust();

