#ifndef lint
static char *SCCSID = "@(#)Dhp7475.c	USGS v.4.1";
#endif
/* hp7475A - desktop plotter */
/* the following defines must be included for all drivers */
#include <varargs.h>
#include "plotter.h"
#define file stdout
static char s[] = "\0";		/* required structure for return */
static XYS cursor = {0, 0, s};	/* data.  "s" may be larger, if needed */
# include <termio.h>
/*	select appropriate baud rate for your system */
# define BAUD B9600
	static int
oldpen;
	static char
*spen;
	static struct {
int	xlim,  ylim;
} lims[2] = { 5000, 3600, 7600, 5000 };
	XYS *
Dhp7475(va_alist) va_dcl {
	va_list vap;
	int cmd, i, pen;
	long	x, y, t;
	XYS *ret = &cursor;

	va_start(vap); cmd = va_arg(vap, int);
	switch(cmd) {
	case D_SCALE:
		if (Dglobal.scale <= 0.)
			Dglobal.scale = 1.;
		goto scaleit;
	case D_INIT:
		if (isatty(i = fileno(file))) { /* set baud rate */
			struct termio term;
			if (ioctl(i, TCGETA, &term) == -1)
				return NULL;
			term.c_iflag |= IXON+IXANY;
			term.c_cflag = (term.c_cflag & ~CBAUD) + BAUD;
			if (ioctl(i, TCSETA, &term)== -1)
				return NULL;
		}
		fputs("IN;\033.I81;;17:\033.N;19:SP1;PU;\n",file);
		fprintf(file,"IP;SC 0,%d,0,%d;\n",
			lims[Dglobal.model_no].xlim,
			lims[Dglobal.model_no].ylim);
		oldpen = 0;
scaleit:
		if (Dglobal.reverse) {
			cursor.x = lims[Dglobal.model_no].ylim / Dglobal.scale;
			cursor.y = lims[Dglobal.model_no].xlim / Dglobal.scale;
		} else {
			cursor.x = lims[Dglobal.model_no].xlim / Dglobal.scale;
			cursor.y = lims[Dglobal.model_no].ylim / Dglobal.scale;
		}
		break;
	case D_DONE:
		fputs("SP0;IN;\n",file);
		fclose(file);
		break;
	case D_MOVE:
		spen = "PU";
	case D_LINE:
		x = (va_arg(vap, long)) * Dglobal.scale;
		y = (va_arg(vap, long)) * Dglobal.scale;
		if (Dglobal.reverse) {
			t = x;
			x = y;
			y = lims[Dglobal.model_no].ylim - t;
		}
		fprintf(file,"%s%d,%d;\n", spen, x, y);
		spen = "PD";
		break;
	case D_PEN:
		pen = (va_arg(vap, long)) & 7;
		pen %= 6;  /* only six pens */
		if (pen != oldpen) {
			oldpen = pen;
			fprintf(file,"SP%d;\n",pen+1);
		}
	}
	va_end(vap);
	return ret;
}
