#ifndef lint
static char *SCCSID = "@(#)Dgerber.c	USGS v.4.1";
#endif
/* Gerber - photohead hi-res plotter */
/* some tape output devices 'swab' bytes.  To counter this
** action define SWAB
*/

#include <varargs.h>
#include "plotter.h"
#include <fcntl.h>

static char s[] = "\0";		/* required structure for return */
static XYS cursor = {0, 0, s};	/* data.  "s" may be larger, if needed */

static int pendown = 2, oldpen = -1;

static int file, SWAB, NL;

# define XPMAX 24000
# define YPMAX 32000
# define RECLEN 72
# define BUFLEN 1*RECLEN
# define TO1000IN(x) (long)((x)*1.96850393700787401574+0.5)
/*
# define TO1000IN(x) (long)((x)*1.+0.5)
*/
	static char
cmdbuf[20], outbuf[BUFLEN+2];
	static int
bufp = 0;
	static char *
penmap[] = {
	"10",	/*	.002" line */
	"11",	/*	.003" line */
	"24",	/*	.004" line */
	"12",	/*	.005" line */
	"25",	/*	.006" line */
	"13",	/*	.007" line */
	"22",	/*	.008" line */
	"23",	/*	.009" line */
	"14",	/*	.010" line */
	"12",	/*	.012" line */
	"16",	/*	.014" line */
	"17",	/*	.015" line */
	"26",	/*	.025" line */
	"27",	/*	.050" line */
};
	static void
flushp() {
	int n;

	if (bufp) {
		n = bufp % RECLEN;
		if (n) while(n++ < RECLEN)
			outbuf[bufp++] = ' ';
		if (NL)
			outbuf[bufp++] = '\n';
		if (SWAB)
			swab(outbuf, outbuf, bufp);
		write(file, outbuf, bufp);
		bufp = 0;
	}
}
	static
putp(str) char *str; {
	int c;

	while (c = *str++) {
		if (bufp >= BUFLEN)
			flushp();
		outbuf[bufp++] = c;
	}
}
	static long
xlast = -1,
ylast = -2;
	XYS *
Dgerber(va_alist) va_dcl {
	va_list vap;
	int cmd, pen;
	long	x, y, t;
	XYS *ret = &cursor;
	static char *spen = "";

	va_start(vap); cmd = va_arg(vap, int);
	switch(cmd) {
	case D_SCALE:
		if (Dglobal.scale <= 0.)
			Dglobal.scale = 1.;
		goto scaleit;
	case D_INIT:
		file = 1;
		SWAB = !(Dglobal.model_no & 1);
		NL = Dglobal.model_no & 2;
		putp("X0Y0D01");
scaleit:
		if (Dglobal.reverse) {
			cursor.y = XPMAX / Dglobal.scale;
			cursor.x = YPMAX / Dglobal.scale;
		} else {
			cursor.x = XPMAX / Dglobal.scale;
			cursor.y = YPMAX / Dglobal.scale;
		}
		break;
	case D_DONE:
		putp("*X0Y0D02*M02*");
		flushp();
		break;
	case D_MOVE:
		if (pendown) {
			pendown = 0;
			spen = "D02";
		}
		goto moveit;
	case D_LINE:
		if (!pendown) {
			pendown++;
			spen = "D01";
		}
moveit:	
		x = (va_arg(vap, long)) * Dglobal.scale;
		y = (va_arg(vap, long)) * Dglobal.scale;
		if (Dglobal.reverse) {
			t = x;
			x = y;
			y = YPMAX - t;
		}
		x = TO1000IN(x);
		y = TO1000IN(y);
		putp("*");
		if  (x != xlast) {
			sprintf(cmdbuf,"X%ld", x);
			xlast = x;
			putp(cmdbuf);
		}
		if  (y != ylast) {
			sprintf(cmdbuf,"Y%ld", y);
			ylast = y;
			putp(cmdbuf);
		}
		putp(spen);
		spen = "";
		break;
	case D_PEN:
		pen = (va_arg(vap, long)) % 14; /* 14 pens */
		if (pen != oldpen) {
			oldpen = pen;
			sprintf(cmdbuf,"*G54D%s*G01D01",penmap[pen]);
			putp(cmdbuf);
			pendown = 1;
		}
	}
	va_end(vap);
	return ret;
}
