# ifndef lint
static char *SCCSID = "@(#)Dcps.c	 v.4.2";
# endif
/* ps - driver for PostScript output */
# define PLOTTER

# include <varargs.h>
# include <unistd.h>
# include "plotter.h"

/* establish number of typesetter points/inch.
** The following is the legal definition is 72.27 pts/in but some machines
** appear to use 72 (even) */
#define PTS_PER_IN 72.0
/* Convert 200 counts/cm to points: 2.54 * 200 */
#define IN_TO_CNTS	508.
/* Maximum default pens when external control not specified */
#define MAX_CPENS 8

#define XPMAX sheet[Dglobal.model_no].xpmax
#define YPMAX sheet[Dglobal.model_no].ypmax

# define MAX_NAME 2000

/* NOTE: x-y axis orientation in the following list is based upon the
**		normal, portrait-mode initial state of most PostScript printers.
**		That is, the x-axis is along the short length of the paper and
**		the y-axis along the long edge.
*/
static struct SHEET {
	float 	xpmax, ypmax;	/* axis size of paper in inches X 508 */
} sheet[] = {
	4319.,	5588.,	/* 8.5x11" standard or A size */
	4319.,	7112.,	/* 8.5x14" legal size */
	5588.,	8636.,	/* 11x17" B size */
};

	static char
s[] = "\0",		/* required structure for return */
*cfile;			/* runline control file input */
static XYS cursor = {0, 0, s};	/* data.  "s" may be larger, if needed */
#define MAX_DXY 50
	static XY
dxy[MAX_DXY];
	static int
nline = 0,
ndxy = 0,
troff = 0,
noshow = 0,
oldpen = -1,
pen,
maxpen = 0,
pendown;
/* initialization strings and PostScript abbreviations */
	static char
*initstr = "\
%%!PS\n\
/SC { %.6g } def\n\
/S { SC div } bind def\n\
/L { {rlineto} repeat } bind def\n\
/U { moveto } bind def\n\
gsave\n",

*init2 = " SC SC scale\n",

*landstr = "\
0 %.1f translate\n\
-90 rotate\n\
",

*portstr = "";
	static float
widths[MAX_CPENS] = {0., .5, 1., 1.5, 2., 3., 5., 7.5};
	static void
setlines() {
	extern char *font_dir[];
	extern char *getenv();
	char *name, nm[MAX_NAME];

	name = cfile ? cfile : "plotter.cps";
	if (access(name, R_OK + F_OK)) {
		strcpy(nm, font_dir[0]);
		strcat(nm, name);
		name = nm;
		if (access(name, R_OK + F_OK)) {
			if (cfile)
				bomb(0,"cps pen file %s not found\n", cfile);
			name = 0;
		}
	}
	if (name) {
		int c;
		FILE *in;

		if (!(in = fopen(name, "r")))
			bomb(1, "color postscript driver %s spec. table not found\n",
				name); /* this should not happen */
		if (fscanf(in, "%%%%!PENS %d", &maxpen) != 1)
			bomb(0, "Could not read cps file %%%%!PENS line\n");
		while ((c = getc(in)) > 0)
			putchar(c);
		fclose(in);
	} else {
		int i;

		maxpen = MAX_CPENS;
		printf(
"/R{ S setlinewidth 0 setgray 1 setlinejoin 1 setlinecap [] 0 setdash} def\n");
		for (i = 0; i < maxpen; ++i)
			printf("/P%d { %g R } def\n/D%d { stroke } def\n", i, widths[i], i);
	}
}
	static void
dump(hold) {
	int n;

	if (!ndxy) {
		if (pendown > 1)	return;
		dxy[0].x = dxy[0].y = 0;
		++ndxy;
	}
	n = ndxy;
	while (n--) /* print out in reverse order */
		if ((nline += printf("%d %d ",dxy[n].x,dxy[n].y)) > 70 && n) {
			(void)putchar('\n');
			nline = 0;
		}
	(void)printf("%d L\n", ndxy);
	if (!hold) {
		(void)printf("D%d\n", pen);
	}
	nline = ndxy = 0;
	++pendown;
}
	static long
x, y, xl, yl, dx, dy;
	extern long
strtol();
	XYS *
Dcps(va_alist) va_dcl {
	va_list vap;
	int cmd, i;
	long lpen;
	XYS *ret = &cursor;
	char *ss;

	va_start(vap); cmd = va_arg(vap, int);
	switch(cmd) {
	case D_SCALE:
		if (Dglobal.scale <= 0.)	Dglobal.scale = 1.;
		goto scaleit;
	case D_INIT:
		for (x = y = 0, i = 1; i < Dglobal.dargc ; ++i)
			switch (*Dglobal.dargv[i]) {
			case 't':	/* troff mode */
				troff = 1;
				Dglobal.reverse = 1;
			case 'x':	/* suppress showpage */
				noshow = 1;
				break;
			case 'o':	/* offset -o<x>,<y> */
				ss = Dglobal.dargv[i];
				x = strtol(++ss, &ss, 0);
				y = strtol(++ss, &ss, 0);
				break;
			case 'f':	/* pen control file source */
				cfile = Dglobal.dargv[i] + 1;
				break;
			default:
				(void)fprintf(stderr,"unknown arg:%s\n",
					Dglobal.dargv[i]);
				ret = (XYS *)0;
			}
		if (!ret) break;
		pendown = 0;
		if (!troff)	printf(initstr, PTS_PER_IN/IN_TO_CNTS);
		puts(init2);
		setlines();
		if (Dglobal.reverse)
			puts(portstr);
		else
			printf(landstr, YPMAX);
		if (x || y)	(void)printf("%d %d translate\n",x,y);
scaleit:
		if (Dglobal.reverse) {
			cursor.x = (troff ? 10000 : XPMAX) / Dglobal.scale;
			cursor.y = (troff ? 10000 : YPMAX) / Dglobal.scale;
		} else {
			cursor.y = XPMAX / Dglobal.scale;
			cursor.x = YPMAX / Dglobal.scale;
		}
		break;
	case D_DONE:
	case D_PANIC:
		if (pendown)	dump(0);
		if (!troff)	puts("grestore\n");
		if (!noshow)	puts("showpage\n");
		break;
	case D_MOVE:
		if (pendown) {
			dump(0);
			pendown = 0;
		}
	case D_LINE:
		x = (va_arg(vap, long)) * Dglobal.scale + .5;
		y = (va_arg(vap, long)) * Dglobal.scale + .5;
		if (pendown) {
			if ((dx = x - xl) | (dy = y - yl)) {
				dxy[ndxy].x = dx;
				dxy[ndxy].y = dy;
				if (++ndxy >= MAX_DXY) dump(1);
			}
		} else {
			nline = printf("%d %d U ", x, y);
			pendown = 1;
		}
		xl = x;
		yl = y;
		break;
	case D_PEN:
		if (pendown)	dump(0);
		lpen = va_arg(vap, long);
		pen = lpen % maxpen;
		if (pen != oldpen) {
			(void)printf("P%d\n",pen);
			pendown = 0;
			oldpen = pen;
		}
		break;
	}
	va_end(vap);
	return ret;
}
