unit raytree;

{$I init.inc}

{*Unit raytree************************************************************

 This unit provides TRayTree, roughly all the basic Ray Tree functions...

 Created            : 07/02/93
 Last Change        : 02/05/93
 Revisions          : none

 *************************************************************************}

interface

uses globals;

type
  TRayTree = object(TPrim)
     constructor Init;
     Function Intersect(Ray : TRay; var Hitlist : PHitList) : byte; virtual;
     Procedure Add(Item : PPrim; Surface : PSurf);
     Destructor Done; virtual;
  end;

var
  Tree : TRayTree;

implementation

{*TRayTree Methods*********************************************************}

Constructor TRayTree.Init;

begin
  TPrim.Init;     { This call initialises Next }
end;

{*Function Intersect*******************************************************

 This is the main intersect function it will call the intersect methods of
 all of the nodes, which will if neccessary intersect its subnodes...

 **************************************************************************}

Function TRayTree.Intersect;

var
  HitTemp : PHitlist;
  smallest_t : Flt;
  p : pprim;
  roots,
  nroots : word;

begin
  nroots:=0;
  smallest_t := 1e+38;
  p := next;
  while p <> nil do
  begin
    stats.nintersects := stats.nintersects + 1;
    New(HitTemp,Init);                      { Create temp Hitlist }
    roots := p^.Intersect(Ray,HitTemp);
    inc(nroots,roots);
    if roots <> 0 then
    begin
      stats.nintersectssucceeded := stats.nintersectssucceeded + 1;
      If HitTemp^.next^.t<smallest_t then
      begin
{       Dispose(Hitlist,Done);  mark/release }
        Hitlist := HitTemp;                   { Old := New }
        smallest_t := Hitlist^.next^.t;
        Hitlist^.next^.prim := p;
      end;
    end;
    p := p^.next;
  end;
  intersect := nroots;
end;

{*Procedure Add************************************************************

 Add an item in raytree

 **************************************************************************}

Procedure TRayTree.Add;

begin
  Item^.next := next;
  next := Item;
  next^.surf := surface;
end;

{*Destructor TRayTree.Done*************************************************

 This destructor disposes the whole raytree by disposing each node, one
 by one, and calling its own destructor (which will dispose its sub-nodes)

 **************************************************************************}

Destructor TRayTree.Done;

var
  Dummy : PPrim;

begin
  while Next<>nil do
  begin
    Dummy := Next^.Next;
    Dispose(Next,Done);
    Next := Dummy;
  end;
end;

end.
