unit planes;

{$I init.inc}

{*Unit Planes************************************************************

 Plane rountines

 Created            : 20/05/93
 Last Change        : none
 Revisions          : none

 ************************************************************************}

interface

uses globals;

type
  PPlane = ^TPlane;
  TPlane = Object(TPrim)
    PlaneNormal : Vec;
    D      : Flt;
    constructor Init(Norm :Vec; D_val : Flt);
    function Intersect(Ray : TRay; var Hitlist : PHitlist) : byte; virtual;
    procedure Normal(P : Point; var N : Vec); virtual;
    destructor Done; virtual;
  end;

implementation

{$I vectors.inc }

{*Plane Routines**********************************************************}

constructor TPlane.Init;

begin
  TPrim.Init;

  PlaneNormal := norm;
  VecUnit(PlaneNormal);

  D := D_Val;

  {$IFDEF Debug}
    PrintVec('Initialised Plane: normal   ',planenormal);
    Writeln(con,'                   distance ',D:7:3);
    writeln(con);
  {$ENDIF}
end;

function TPlane.Intersect;

var
  vd,
  v0,
  t      : Flt;

begin

  {$IFDEF Debug}
     PrintVec(   'Intersecting Plane: normal   ',planenormal);
     Writeln(con,'                    distance ',D:7:3);
     writeln(con);
  {$ENDIF}

  stats.plnintersects := stats.plnintersects + 1;

  vd := VecDot(PlaneNormal, Ray.D);
  
  if vd = 0 then begin intersect := 0; exit; end;

  v0 := -(VecDot(PlaneNormal, Ray.P) + D);

  t := v0/vd;

  if t>rayeps then
  begin
    Hitlist^.Add(New(PHititem,Init(t,0,@self)));
    {$IFDEF Debug}
      writeln(con, 'Found intersection ',t:7:3); writeln(con);
    {$ENDIF Debug}
    stats.plnintersectssucceeded := stats.plnintersectssucceeded + 1;
    intersect:=1;
  end
  else
    intersect:=0; {maybe not neccessary}
end;

procedure TPlane.Normal;

begin
  N := PlaneNormal;
end;

destructor TPlane.Done;

begin
end;

end.
