{$i-}
unit convert;

interface
         uses crt;

         type xyz=record
              x: string[10];
              y: string[10];
              z: string[10];
         end;

         type element=record
              atom: string[3];
              color: string;
              radius: string[5];
         end;

         const
              fehler_text: array[0..5] of string = ('No Errors',
                           'Error in atomdeclaration-file',
                           'Error in input-file',
                           'Error writing output-file',
                           '',
                           'Unknown element');

         var
            camera: xyz;
            look_at: xyz;
            light_source: xyz;
            light_color: string[30];
            back_color: string[30];
            stick_color: string[30];
            include_file: string[79];
            scaling: string[5];
            swapxy: boolean;
            shadows: boolean;

         procedure mol2pov (input_file: string; output_file: string;
                   dat_file: string; radius: string; var fehler: integer);

implementation

var
   ch: file of char;
   key: char;
   buffer, buffer_1, buffer_2: string;
   known_atoms, count_1, count_2: integer;
   found: boolean;
   dats: array[0..120] of element;
   input, output, dat: text;

{Writes the opening of the Povray-file}
procedure write_header (var fehler: integer);
begin
     rewrite (output);
     if ioresult <> 0 then fehler := 3;
     writeln (output, '#include "colors.inc"');
     if ioresult <> 0 then fehler := 3;
     if include_file <> '' then writeln (output, '#include "' +
        include_file + '"');
     if ioresult <> 0 then fehler := 3;
     writeln (output, 'camera { location < ' + camera.x + ', ' +
             camera.y + ', ' + camera.z + ' > look_at < ' +
             look_at.x + ', ' + look_at.y + ', ' + look_at.z + ' > }');
     if ioresult <> 0 then fehler := 3;
     writeln (output, 'light_source { < ' + light_source.x + ', ' +
             light_source.y + ', ' + light_source.z + ' > color ' +
             light_color + ' }');
     if ioresult <> 0 then fehler := 3;
     writeln (output, 'background { color ' + back_color + ' }');
     if ioresult <> 0 then fehler := 3;
     close (output);
     if ioresult <> 0 then fehler := 3;
     if fehler <> 0 then exit;
end;

{Reads one single word}
procedure read_word (var fehler: integer);

begin
     buffer := '';
     repeat
           read (ch, key);
           if ioresult <> 0 then fehler := 2;
     until (key >= '!') or eof (ch);
     repeat
           buffer := buffer + key;
           read (ch, key);
           if ioresult <> 0 then fehler := 2;
     until (key < '!') or eof (ch);
end;

{Converts a MOL-file in a POV-file (Space-filling)
The sections of the module have the same function as in LIS2POV}
procedure mol2pov (input_file: string; output_file: string;
          dat_file: string; radius: string; var fehler: integer);

var
   coordinate: xyz;
   number: integer;
   atom: array[1..1000] of xyz;

begin
     fehler := 0;
     assign (ch, input_file);
     assign (output, output_file);
     assign (dat, dat_file);

     reset (dat);
     if ioresult <> 0 then begin
        fehler := 1;
        exit;
     end;
     count_1 := 0;
     repeat
           readln (dat, buffer_1);
           if ioresult <> 0 then fehler := 1;
           if (buffer_1[1] <> ';') and
              (buffer_1[1] <> '*') and
              (buffer_1[1] <> '#') then begin
              count_1 := count_1 + 1;
              dats[count_1].atom := '';
              count_2 := 0;
              buffer_2 := '';
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] >= '!');
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] < '!');
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] >= '!');
              repeat
                    buffer_2 := buffer_2 + buffer_1[count_2];
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] < '!');
              dats[count_1].radius := buffer_2;
              buffer_2 := '';
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] >= '!');
              repeat
                    buffer_2 := buffer_2 + buffer_1[count_2];
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] < '!');
              dats[count_1].color := buffer_2;
              buffer_2 := '';
              repeat
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] >= '!');
              repeat
                    buffer_2 := buffer_2 + buffer_1[count_2];
                    count_2 := count_2 + 1;
              until (count_2 > length (buffer_1)) or (buffer_1[count_2] < '!');
              dats[count_1].atom := buffer_2;
           end;
     until eof (dat);
     known_atoms := count_1;
     if known_atoms < 1 then fehler := 1;
     close (dat);
     if ioresult <> 0 then fehler := 1;
     if fehler <> 0 then exit;

     write_header (fehler);

     append (output);
     if ioresult <> 0 then fehler := 3;
     reset (ch);
     if ioresult <> 0 then fehler := 2;
     if fehler <> 0 then exit;

     read_word (fehler);
     buffer_1 := buffer;
     val (buffer_1, number, fehler);
     if fehler <> 0 then fehler := 2;
     if fehler <> 0 then exit;

     count_2 := 1;
     repeat
           count_1 := 0;
           read_word (fehler);
           buffer_2 := buffer;
           read_word (fehler);
           coordinate.x := buffer;
           read_word (fehler);
           coordinate.y := buffer;
           read_word (fehler);
           coordinate.z := buffer;
           read_word (fehler);
           if swapxy then begin
              buffer := coordinate.x;
              coordinate.x := coordinate.y;
              coordinate.y := buffer;
           end;

           count_1 := 0;
           found := false;
           repeat
                 count_1 := count_1 + 1;
                 if buffer_2 = dats[count_1].atom then begin
                    writeln (output, 'object { sphere { < ' +
                            coordinate.x + ', ' +
                            coordinate.y + ', ' +
                            coordinate.z + ' > ' +
                            dats[count_1].radius + ' * ' + scaling);
                    writeln (output, 'pigment { ' +
                            'color ' + dats[count_1].color +
                            ' } finish { phong 0.85 '+
                            'phong_size 100 } }');
                    if shadows then writeln (output, ' }')
                       else writeln (output, ' no_shadow }');

                    atom[count_2] := coordinate;
                    found := true;
                 end;
                 if buffer_2 = '0' then found := true;
           until count_1 = known_atoms;
           if found = false then fehler := 5;
           count_2 := count_2 + 1;
     until (count_2 > number) or (eof (ch));

     if fehler <> 0 then begin
        close (output);
        close (ch);
        exit;
     end;

     if radius <> '0' then begin
        read_word (fehler);
        if fehler <> 0 then exit;

        read_word (fehler);
        repeat
              val (buffer, count_1, fehler);
              read_word (fehler);
              val (buffer, count_2, fehler);
              writeln (output, 'object { cylinder { < ' +
                      atom[count_1].x + ', ' +
                      atom[count_1].y + ', ' +
                      atom[count_1].z + ' >, <' +
                      atom[count_2].x + ', ' +
                      atom[count_2].y + ', ' +
                      atom[count_2].z + ' >, ' +
                      radius);
              writeln (output, 'pigment { ' +
                      stick_color +
                      ' } finish { phong 0.85 '+
                      'phong_size 100 } }');
              if shadows then writeln (output, ' }')
                 else writeln (output, ' no_shadow }');

              read_word (fehler);
              read_word (fehler);
        until (fehler <> 0) or (eof (ch)) or (buffer = '0');
     end;
     close (ch);
     if ioresult <> 0 then fehler := 2;
     close (output);
     if ioresult <> 0 then fehler := 3;
     if fehler <> 0 then exit;
end;
end.
