
#include "SDLL.h"
#include "assert.h"

void
SDLListBase::discardHead()
{

  SDLLNode *temp=_first;

  assert(temp!=0);

  _first=_first->_next;

  if ( _first != 0 ) _first->_prev=0;

  //  DLLNodeFactory::the()->recycle(temp);
  delete temp;
}

void
SDLListBase::_addToEnd(void *ptr)
{

  if (_first == 0) {
    _first=_last=new SDLLNode(ptr,0,0);  
  }  else  {
    assert( _last != 0 );
    _last->_next=new SDLLNode(ptr,_last,0);
    _last=_last->_next;
  }
}


bool
SDLListBase::_contains(void *findme) const
{

  if (_first == 0) return false;
  
  SDLLNode *node=_first;

  do
    {
      if (node->_ptr == findme) return true;
    }
  while( (node=node->_next) != 0 );

  return false;

}


int
SDLListBase::_find(const void *findme) const 
{

  
  if (_first == 0) return -1;
  
  SDLLNode *node=_first;

  int num=0;

  do {
    if (node->_ptr == findme) return num;
    num++;
  }
  while( (node=node->_next) != 0 );

  return -1;

}


int
SDLListBase::count() const
{

  int count=0;
  SDLLNode *node=_first;

  while (node != 0) {
    count++;
    node=node->_next;
  }

  return count;

}

void *
SDLListBase::_at(int count) 
{


  SDLLNode *node=_first;

  
  while (node != 0) {
    if (count == 0) return node->_ptr;
    count--;
    node=node->_next;
  }

  return 0;

}


void
SDLListBase::_addToStart(void *ptr)
{

  if (_first == 0)
    {
      _first=_last=new SDLLNode(ptr,0,0);  
    }
  else
    {
      assert( _last != 0 );
      _first->_prev=new SDLLNode(ptr,0,_first);
      _first=_first->_prev;
    }
}



void
SDLListBase::_insertBefore(SDLLNode *node,void *ptr)
{
  assert(   ptr != 0 );
  assert(  node != 0 );
  assert( _last != 0 );

  SDLLNode *newNode=new SDLLNode(ptr,node->_prev,node);

  if (node->_prev != 0) 
    {
      node->_prev->_next=newNode;
    }

  node->_prev       =newNode;

  if (node == _first) _first=newNode;

}






