#include <iostream.h>

#include "JMidiOutEvent.h"
#include "JReader.h"


ostream & operator << (ostream &out,JMidiOutEvent e)
{
  out << e.deviceId() << " ";
  out << e.channelId() << " ";
  out << (int)(e.type()) << " ";
  out << e.index()  << " ";
  out << e.value();
  return  out;
}


void
JMidiOutEvent::debugOut(ostream &out) const
{
  out << " dev=" << deviceId();
  out << " chn=" << channelId();
  out << " typ=" << type();
  out << " ind=" << index();
  out << " val=" << value();
}


bool 
JMidiOutEvent::read(JReader &in)
{

   //  char buff[2];
   int iType;

   if (!in.getInt(_dev)) return false;
   if (!in.getInt(_chn)) return false;
   if (!in.getInt(iType)) return false;
   _type = JMidiOutType(iType) ;
   if (!in.getInt(_index)) return false;
   if (!in.getInt(_value)) return false;

   return  true;
}












