#include "QJTrackItem.h"
#include "QJCompositionView.h"
#include "jam/JTrack.h"
#include "jam/JVoice.h"
#include "assert.h"
#include "jam/JContext.h"
#include "jam/JFocus.h"
#include "jam/JPlayer.h"
#include "jam/JMapper.h"
#include "jam/JDevice.h"
#include "jam/JDeviceManager.h"


QJTrackItem::QJTrackItem( QListViewItem * parent ,
			  JTrack *t , 
			  JContext *context)
    : QListViewItem( parent ),
      _track(t) ,
      _context(context),
      _columnSelected(-1)
{

}

QJTrackItem::QJTrackItem( QListView * parent , JTrack *t , JContext *context)
    : QListViewItem( parent ), _track(t) , _context(context)
{

}


QJTrackItem::~QJTrackItem()
{

}

void QJTrackItem::setOpen( bool )
{
  

}

void QJTrackItem::setup()
{
    setExpandable( FALSE );
    QListViewItem::setup();
}


QString QJTrackItem::fullName()
{
    return _track->name();
}


// void
// QJTrackItem::editAt(int col)
// {
//   JVoice *voice=_track->player()->voice();
//   assert(voice != 0);

//   switch
//(c) {
//   case 3:
//     _colgrab=col;
//     grabMouse=voice->channelId();
    


// }


void
QJTrackItem::cycleSelectedColumn(int jmp)
{
  int i;
  int n;

  JVoice *voice=_track->player()->voice();
  assert(voice != 0);

  switch(_columnSelected) {

  case 1:
    voice->setMute(!voice->isMute());
    break;

  case 2:

    i=voice->deviceId();
    n=JDeviceManager::the()->nOutDevice();
    i = (i+jmp+n)%n;
    voice->setDeviceId(i);
    break;

  case 3:
    i=voice->channelId();
    i = (i+jmp+16)%16;
    voice->setChannelId(i);
    break;

  case 4:
    i=voice->programId();
    i = (i+jmp+128)%128;
    voice->setProgramId(i);
    break;


  case 5:
    i=voice->bankId();
    i = (i+jmp+128)%128;
    voice->setBankId(i);
    break;


  default:
    break;
  }

  return;

}

void
QJTrackItem::paintCell(QPainter * p,
		      const QColorGroup & cg, 
		      int col, int wid , int align)
{
  QListViewItem::paintCell(p,cg,col,wid,align);
  if (col == _columnSelected) {
    p->setPen(black);
    p->drawRect(0,0,wid-1,height()-1);
  }
}

const char * 
QJTrackItem::text( int column ) const
{
  static QString s;

  JVoice *voice=_track->player()->voice();

  switch (column) {
  case 0:  
    s=_track->name();
    return s;

  case 1:
    return voice->isMute() ? "M" : " ";

  case 2:
    if (voice != 0 ) {
      s.sprintf("%s",voice->defaultDeviceName());
    }
    return s;

  case 3:
    if (voice != 0 ) {
      s.sprintf("%d",voice->channelId());
    }
    return s;

  case 4:
    if (voice != 0 ) {
      s.sprintf("%d", voice->programId() );
      return s;
    }
    break;

  case 5:
    if (voice != 0 ) {
      // TODO patch look up
      s.sprintf("%d", voice->bankId() );
      return s;
    }
    break;


  default:
    return 0;
  }

  return 0;
}

void QJTrackItem::activate()
{
  _context->focus()->setTrack(_track);
}
  
  









