#ifndef _QJScoreWidget_H
#define _QJScoreWidget_H

#include <qframe.h>
#include <qpixmap.h>
#include "jam/JTrackUpdate.h"
#include "rep/JBeat.h"
#include "base/JOSTemplate.h"

/*!
  \class QJScoreWidget QJScoreWidget.h
  \brief parent widget for the trackScoreWidgets

*/

class QJScoreTool;
class QJPhraseEditor;
class JScoreController;
class JFocus;
class QJTrackScore;
class QJEditCntrl;
class JBeat;
class QJScoreTimeMarker;
class JBeatToX;
class JTrackUpdate;
class JCursor;
class JTrack;
class JConductor;
class JBPT;
class JContext;

class QJScoreWidget: public QFrame,
		     public JObserver<const JFocus *,void>,
		     public JObserver<JTrackUpdate ,void>,
		     public JObserver<const JCursor *,void>,
		     public JObserver<const JBPT *,void>

{
  Q_OBJECT
public:
  QJScoreWidget(JContext *,
		QWidget *parent);
  ~QJScoreWidget();
  void handle(const JFocus *focus);
  void handle(JTrackUpdate);
  void handle(const JCursor *);
  void handle(const JBPT *);

  const char *name() const { return QWidget::name(); }

  void resizeEvent(QResizeEvent *);


public  slots:
  void playTimeUpdate(JBeat beat);
  void aMousePressEvent(QMouseEvent *);
  void aMouseReleaseEvent(QMouseEvent *);
  void aMouseMoveEvent(QMouseEvent *);


private:

  void setTimeMarkers();
  QJTrackScore *        _trackScore;
  QJEditCntrl  *        _editCntrl;
  QJPhraseEditor *      _phraseEditor;
  QJScoreTimeMarker *   _timeMarker;
  QJScoreTimeMarker *   _leftMarker;
  QJScoreTimeMarker *   _rightMarker;
  JBeatToX *            _beatToX;
  JBeat                 _leftBeat;
  const JTrack *        _track;
  JConductor *          _conductor;
  const JFocus *        _focus;
};



#endif








