#include <qpushbt.h>
#include <qcombo.h>
#include <qtooltip.h>


#include "jam/JKnob.h"
#include "QJMapperWidget.h"
#include "jam/JKnobTable.h"
//#include "jam/JChannel.h"
#include "jam/JEffect.h"


QJMapperWidget::QJMapperWidget(JMapper *mapper
			       QWidget *parent, const char *name )
  : QGroupBox( parent, name),
    _knob(0),
    _effect(0),
    _mapper(mapper)
{




  //  QGroupBox *group=new QGroupBox(this,name);

  setTitle("Controller->Effect");

  QComboBox *combo = new QComboBox( FALSE, this, "control" );

  combo->setStyle(WindowsStyle);
  JListIterator <JKnob> knobs(_mapper->knobs());

  JKnob *knob;

  _knob=0;
  while( (knob = knobs.next()) != 0) {
    if (_knob==0) _knob=knob;
    combo->insertItem( knob->name() );
  }


  combo->setGeometry( 10, 20, 120, 20 );


  //  connect( combo, SIGNAL(activated(int)), SLOT(knobSlotActivated(int)) );
  connect( combo, SIGNAL(highlighted(int)), SLOT(knobSlotHighlighted(int)) );

  QToolTip::add( combo, "Controller select" );



  JListIterator <JEffect> effects(_mapper->channel()->effectList());
  JEffect *effect;

  _effect=0;
  int count=0;

  while( ( effect=effects.next()) != 0 )  {
    _effectNames.insert(count++,effect->name() );
  }

  _effectNames.insert(count, "/dev/null" );

  _effect=0;

  _effectCombo = new QComboBox( FALSE, this , "effect" );

  _effectCombo->setStyle(WindowsStyle);
  _effectCombo->insertStrList(&_effectNames);

  _effectCombo->setCurrentItem(count);
  _effectCombo->setGeometry( 130, 20, 120, 20 );


  connect( _effectCombo, SIGNAL(activated(int)), SLOT(effectSlotActivated(int)) );
  QToolTip::add( combo, "Effect select" );
  adjustSize();

  knobSlotHighlighted(0);
}

void 
QJMapperWidget::setMap()
{
  if (_knob == 0) return;
  if (_effect != 0)
    warning( " %s --> %s \n",_knob->name(),_effect->name());
  // All that work just to
  _knob->setEffect(_effect);
}


// void
// QJMapperWidget::knobSlotActivated(int n)
// {
//   _knob = (*_knobList)[n];
// }


void
QJMapperWidget::knobSlotHighlighted(int n)
{
  _knob = _knobList->at(n);
  assert(_knob != 0);
  _effect=_knob->effect();
  if (_effect == 0 ) {
    _effectCombo->setCurrentItem(_effectList->count());
  } else {
    int i= _effectNames.find(_effect->name());
    _effectCombo->setCurrentItem(i);
  }
  setMap();
}



void
QJMapperWidget::effectSlotActivated(int n)
{
  if (n >= _effectList->count()) {
    _effect=0;
    setMap();
    return;
  }
  _effect= _effectList->at(n);
  setMap();
}


















