#ifndef _JDeviceChannel_H
#define _JDeviceChannel_H


/*!
  \class JEffectTable JEffectTable.h
  \brief Base class for mapping effects onto a device channel.
         This class is intended to be subclassed

 */

#include "JEffectList.h"
#include "JEffect.h"

#include "assert.h"
#include "JEffectType.h"
#include "JName.h"


class JEffect;
class JEffectEvent;
class JMidiOutEvent;
class JMidiOutDevice;
class JDevice;

class JDeviceChannel : public JName
{

public:

  JDeviceChannel(JMidiOutDevice * device , int chan);
  virtual ~JDeviceChannel();

  JEffect * lookUp(JEffectEvent event) const;
  JEffect * lookUp(JEffectType type,int index) const;

  /// Standard effects are hard wired ?
  JEffect * noteEffect(int i) ;
  void      buildTable();

  JEffect * pitchBendEffect()  { return _pitchBend; }
  JEffect * programEffect()    { return _program; }
  JEffect * resetEffect()      { return _reset; }
  JEffect * allNoteOffEffect() { return _allNoteOff; }

  // GUI would like a list 
  JEffectList * effectList() { return _effectList; }

  int              id() const { return _id; }
protected:
  JMidiOutDevice *  _device;
  int               _id;
  JEffect *         _notes[128];
  JEffect *         _cntlEffect[128];
  JEffect *         _auxEffect[128];
  JEffect *         _pitchBend;
  JEffect *         _program;
  JEffect  *        _reset;
  JEffect  *        _allNoteOff;
  JEffectList *     _effectList;
  static int        _idCount;
  static JEffect *  _nullEffect;
};


inline
JEffect *
JDeviceChannel::noteEffect(int i) 
{ 
  assert( i >=0 && i < 128);
  return _notes[i];
}

#endif






