#ifndef _JMidiFileProcessor_H
#define _JMidiFileProcessor_H

#include "MidiEvent.h"
#include "MidiInfo.h"
#include <stdio.h>

class JMidiFileProcessor
{
public:
  JMidiFileProcessor(const char *file);

  bool fail() const { return _fail; }
  bool         processFile();
  bool         isDrumChannel(int ch);

  virtual       ~JMidiFileProcessor(){;}
  virtual void initialize()=0;
  virtual bool processEvent(const MidiEvent *event)=0;

private:
  FILE *       _fp;
  MidiInfo     _glinfo;
  MidiEvent *  _ev;
  bool         _fail;

};



#endif
