#include <iostream.h>

#include "JEffectEventGesture.h"
//#include "JEffectEventNotator.h"
#include "seq/JEffectEventSequencer.h"
#include "rep/JReader.h"

JEffectEventGesture::JEffectEventGesture(JBeat b,JMidiOutEvent e)
  :JGesture(b),
   _event(e)
{
};


JGesture *
JEffectEventGesture::clone() const
{
  return new JEffectEventGesture(_start,_event);
};

JSequencer *
JEffectEventGesture::createSequencer(JPlayer *p) const
{
  return new JEffectEventSequencer(this,p);
}

// JNotator *
// JEffectEventGesture::createNotator(JScorePainter *p) const
// {
//   return new JEffectEventNotator(p,this);
// }


bool
JEffectEventGesture::write(ostream &out) const
{

  out << typeName() 
      << " " <<  _start << " " <<  _event;
  

  return !out.fail();
}


bool
JEffectEventGesture::read(JReader &in)
{
  in.getBeat(_start);
  _event.read(in);
  return !in.fail();
}






