#include <iostream.h>
#include <ctype.h>

#include "japp/JApplication.h"
#include "jam/JMidiIn.h"
#include "jam/JVoice.h"
#include "jam/JSequence.h"
#include "seq/JSequencer.h"
#include "jam/JTimer.h"
#include "jam/JConductor.h"
#include "rep/JMidiInEvent.h"
#include "jam/JVoiceManager.h"
#include "jam/JDeviceManager.h" 
#include "jam/JDevice.h" 


class MyTicker:public JSequencer
{
public:
  MyTicker(JVoice *voice,int pitch):
    _voice(voice),
    _midiOnNote(pitch,70),
    _midiOffNote(pitch,0),
    _onNext(true),
    _nextBeat(JBeat::endOfTime())
  {;}

  /// Time of next event;
  JBeat nextBeat() 
  { return _nextBeat; }

  JBeat gotoBeat(const JBeat &when)
  { return _nextBeat=when; }

  JBeat execute();
private:
  JVoice *       _voice;
  JMidiNoteEvent _midiOnNote;
  JMidiNoteEvent _midiOffNote;
  bool           _onNext;
  JBeat          _nextBeat;
};

JBeat
MyTicker::execute()
{
  if (_onNext) {
    _voice->handle(_midiOnNote);
    _nextBeat += JDuration(0,3,4);
    _onNext = false;
  } else {
    _voice->handle(_midiOffNote);
    _nextBeat += JDuration(0,1,4);
    _onNext = true;
  }
  return _nextBeat;

}

class MyTick:public JSequence
{
public:
  MyTick(JVoice *voice):_voice(voice){;}
  JSequencer * createSequencer(JPlayer *) const;
  //  JEditor *editor() { return 0; }
private:
  JVoice * _voice;
};

JSequencer *
MyTick::createSequencer(JPlayer *) const
{
  return new MyTicker(_voice,56);  // COW BELL ??
}

int main()
{
  // Wrapper for /dev/sequencer


  JDeviceManager *manager=JDeviceManager::the();

  JApplication japp;


  int nDev = manager->nOutDevice();
  int i;

  cout << "\n Supported Devices" << endl;

  for(i=0; i < nDev ; i++ ) {
    cout << "[" << i << "] " <<  manager->outDevice(i)->name() << endl;
  }

  do {
    cout << " Enter the device you want to torture :";
    cin  >> i;
  } while (i <0 && i >= nDev);

  JVoiceManager::the()->setDefaultDevice(i);

  // Wrapper for the midi in stream


  assert(manager->nInDevice() > 0 );

  JMidiIn *midiIn=manager->midiIn(0);

  JVoice *voice =   JVoiceManager::the()->defaultVoice();

  midiIn->attach(voice);

  voice =   JVoiceManager::the()->newVoice("DRUM");
  voice->setChannelId(9);

  MyTick tick(voice);

  JConductor conductor(&tick);

  conductor.handle(JConductorCommand::START);

  cout << " <> adjust tempo\n Q - quit \n";

  char c=' ';

  cin.rdbuf()->unbuffered(0);

  do {
    char buff[132];
    cin.read(buff,1);
    c=buff[0];
    switch(c) {
    case '>':
	cout << " increase tempo " << endl;
	JTimer::the()->setTempo(JTimer::the()->tempo()*1.1);
	break;
    case '<':
	cout << " decrease tempo " << endl;
	JTimer::the()->setTempo(JTimer::the()->tempo()*0.9);
	break;
    }
  } while(toupper(c) != 'Q'); 
}










