#include <iostream.h>
#include "random.h"
#include "scaleanl.h"
#include "phrase.h"
#include "rhytmblk.h"
#include "iterator.h"
#include "flowanal.h"

scale_analyse_c::scale_analyse_c(){
  phrase_ptr = 0;
  clear_main_closest();
  clear_sub_closest();

  // Set scale identifiers //
  major_s_int[12][0] = 0;
  minor_harmonic_s_int[12][0] = 1;
  first_note_ptr = 0;
  last_note_ptr = 0;
  initialise_scales();
}

scale_analyse_c::scale_analyse_c(phrase_c *phrase_p){
  phrase_ptr = phrase_p;
  clear_main_closest();
  clear_sub_closest();

  // Set scale identifiers //
  major_s_int[12][0] = 0;
  minor_harmonic_s_int[12][0] = 1;
  first_note_ptr = 0;
  last_note_ptr = 0;
  initialise_scales();
}

void scale_analyse_c::scale_analyse(){
  rhythm_block_c *start_p = phrase_ptr->phrase();
  rhythm_block_c *end_p = phrase_ptr->phrase()->rLlink();
  clear_main_closest();
  remove_note_arrays();
  identify_notes(start_p, end_p);
  compare_scale(major_s_int, main_closest_scale_int);
  compare_scale(minor_harmonic_s_int, main_closest_scale_int);
}                 

void scale_analyse_c::scale_analyse(rhythm_block_c *start_p,
									rhythm_block_c *end_p, int closest_i){
  clear_sub_closest();
  remove_note_arrays();
  identify_notes(start_p, end_p);
  if(closest_i == 0){
	 compare_scale(major_s_int, sub_closest_scale_int);
	 compare_scale(minor_harmonic_s_int, sub_closest_scale_int);
  }else if(closest_i == 1){
	 compare_scale(major_s_int, sub2_closest_scale_int);
	 compare_scale(minor_harmonic_s_int, sub2_closest_scale_int);
  }
}

void scale_analyse_c::find_base_chord(flow_analyse_c *flow_p,
													int *fraction_array_p,
													int *rfraction_array_p,
													int main_closest_int){
  rhythm_block_c *Lstart_p;
  rhythm_block_c *Lend_p;
  rhythm_block_c *Rstart_p;
  rhythm_block_c *Rend_p;
  int exist_i = 0;
  int exit_i = 0;
  int no_notes_i = 0;

//  char d;

  exist_i = phrase_ptr->find_rhythm_block(fraction_array_p);

  Lend_p = phrase_ptr->iterator()->rhythm_block()->rLlink();

  if(rfraction_array_p != 0){
	 phrase_ptr->find_rhythm_block(rfraction_array_p);
	 // Should always exist //

	 Rstart_p = phrase_ptr->iterator()->rhythm_block();
	 phrase_ptr->iterator()->set_iterator(Lend_p->rRlink(), Lend_p->rRlink());
  }else if(exist_i == 1){
	 Rstart_p = phrase_ptr->iterator()->rhythm_block()->rRlink();
  }else if(exist_i != 1){
	 Rstart_p = phrase_ptr->iterator()->rhythm_block();
  }

  while(exit_i == 0){
	 phrase_ptr->iterator()->iterate(1, 1);

	 if(phrase_ptr->iterator()->no_notes() != 0){
		Lstart_p = phrase_ptr->iterator()->rhythm_block();
		exit_i = 1;
	 }else if(no_notes_i >= 3){
		if(flow_p->flow_locate(phrase_ptr->iterator()->rhythm_block()->array())
			!= 0){
		  Lstart_p = phrase_ptr->iterator()->rhythm_block();
		  exit_i = 1;
		}
	 }

	 no_notes_i++;
  }

  exit_i = 0;
  no_notes_i = 0;

  phrase_ptr->iterator()->set_iterator(Rstart_p, Rstart_p);

  while(exit_i == 0){
	 if(phrase_ptr->iterator()->no_notes() != 0){
		Rend_p = phrase_ptr->iterator()->rhythm_block();
		exit_i = 1;
	 }else if(no_notes_i >= 3){
		if(flow_p->flow_locate(phrase_ptr->iterator()->rhythm_block()->array())
			!= 0){
		  Rend_p = phrase_ptr->iterator()->rhythm_block();
		  exit_i = 1;
		}
	 }

	 no_notes_i++;
	 phrase_ptr->iterator()->iterate(0, 1);
  }

  /*
  cout << "L start: " << Lstart_p->beat() << ", " << Lstart_p->numerator()
		 << "/" << Lstart_p->denominator() << endl;
  cout << "L end: " << Lend_p->beat() << ", " << Lend_p->numerator()
		 << "/" << Lend_p->denominator() << endl;
  cout << "R start: " << Rstart_p->beat() << ", " << Rstart_p->numerator()
		 << "/" << Rstart_p->denominator() << endl;
  cout << "R end: " << Rend_p->beat() << ", " << Rend_p->numerator()
		 << "/" << Rend_p->denominator() << endl;
  */

  scale_analyse(Lstart_p, Lend_p, 0);
  scale_analyse(Rstart_p, Rend_p, 1);

  identify_chords_to_fit(main_closest_int);

}

void scale_analyse_c::remove_all(){
  remove_note_arrays();
}

void scale_analyse_c::display_closest_scale(){
  cout << "stored: " << main_closest_scale_int[0][0] << ", type: "
		 << main_closest_scale_int[0][1] << ", " << main_closest_scale_int[0][2]
		 << endl;
  cout << "stored: " << main_closest_scale_int[1][0] << ", type: "
		 << main_closest_scale_int[1][1] << ", " << main_closest_scale_int[1][2]
		 << endl;
  cout << "stored: " << main_closest_scale_int[2][0] << ", type: "
		 << main_closest_scale_int[2][1] << ", " << main_closest_scale_int[2][2]
		 << endl;
  cout << "stored: " << main_closest_scale_int[3][0] << ", type: "
		 << main_closest_scale_int[3][1] << ", " << main_closest_scale_int[3][2]
		 << endl;
  cout << "stored: " << main_closest_scale_int[4][0] << ", type: "
		 << main_closest_scale_int[4][1] << ", " << main_closest_scale_int[4][2]
		 << endl;
  cout << "stored: " << main_closest_scale_int[5][0] << ", type: "
		 << main_closest_scale_int[5][1] << ", " << main_closest_scale_int[5][2]
		 << endl;
}

void scale_analyse_c::set_base_chord_int(int key_note_i){
  int a;
  int note_pos_i = 0;
  int last_chord_note_i = key_note_i;
  int last_phrase_note_i = key_note_i;
  int note_to_fit_i[2] = {0,0};

  // tmp_int is the main phrase scale, tmp2_int is the base chord notes //

  if(main_closest_scale_int[0][1] == 0){
	 set_tmp_array(tmp_int, major_s_int);
	 for(a = 0;a < main_closest_scale_int[0][0]; a++)
		shift_12_2_array(tmp_int);
  }else{
	 set_tmp_array(tmp_int, minor_harmonic_s_int);
	 for(a = 0;a < main_closest_scale_int[0][0]; a++)
		shift_12_2_array(tmp_int);
  }

  a = key_note_i;

  do{
	 if((tmp2_int[a][0] == 1)&&(tmp_int[a][0] <= 0)){
		if(last_phrase_note_i != last_chord_note_i){
		  tmp2_int[last_phrase_note_i][0] = 1;
		  tmp2_int[a][0] = 0;
		}else{
		  note_to_fit_i[0] = a;
		  note_to_fit_i[1] = 1;
		}
	 }else if((note_to_fit_i[1] == 1)&&(tmp2_int[a][0] == 0)
				&&(tmp_int[a][0] > 0)){
		tmp2_int[a][0] = 1;
		tmp2_int[note_to_fit_i[0]][0] = 0;
		note_to_fit_i[1] = 0;
	 }
	 if(tmp2_int[a][0] == 1)
		last_chord_note_i = a;
	 if(tmp_int[a][0] > 0)
		last_phrase_note_i = a;

	 a++;
	 if(a == 12)
		a = a - 12;
  }while(a != key_note_i);

  a = key_note_i;

  do{
	 if(tmp2_int[a][0] == 1){
		base_chord_int[note_pos_i] = a;
		note_pos_i++;
	 }

	 a++;
	 if(a == 12)
		a = a - 12;
  }while(a != key_note_i);
}

void scale_analyse_c::eliminate_notes(){
  tmp_int[11][0] = tmp_int[11][0] + tmp2_int[11][0] + tmp3_int[11][0];
  tmp_int[10][0] = tmp_int[10][0] + tmp2_int[10][0] + tmp3_int[10][0];
  tmp_int[9][0] = tmp_int[9][0] + tmp2_int[9][0] + tmp3_int[9][0];
  tmp_int[8][0] = tmp_int[8][0] + tmp2_int[8][0] + tmp3_int[8][0];
  tmp_int[7][0] = tmp_int[7][0] + tmp2_int[7][0] + tmp3_int[7][0];
  tmp_int[6][0] = tmp_int[6][0] + tmp2_int[6][0] + tmp3_int[6][0];
  tmp_int[5][0] = tmp_int[5][0] + tmp2_int[5][0] + tmp3_int[5][0];
  tmp_int[4][0] = tmp_int[4][0] + tmp2_int[4][0] + tmp3_int[4][0];
  tmp_int[3][0] = tmp_int[3][0] + tmp2_int[3][0] + tmp3_int[3][0];
  tmp_int[2][0] = tmp_int[2][0] + tmp2_int[2][0] + tmp3_int[2][0];
  tmp_int[1][0] = tmp_int[1][0] + tmp2_int[1][0] + tmp3_int[1][0];
  tmp_int[0][0] = tmp_int[0][0] + tmp2_int[0][0] + tmp3_int[0][0];
}

void scale_analyse_c::identify_chords_to_fit(int main_closest_i){
  int random_i;
  int a;
  int key_i;
  int maj3_i;
  int per5_i;
  int note_to_add_i;
//  int next_i;
  int tmp_array_p[13];
//  char d;

  if(main_closest_scale_int[main_closest_i][1] == 0){
	 set_tmp_array(tmp_int, major_s_int);
	 for(a = 0;a < main_closest_scale_int[main_closest_i][0]; a++)
		shift_12_2_array(tmp_int);
  }else{
	 set_tmp_array(tmp_int, minor_harmonic_s_int);
	 for(a = 0;a < main_closest_scale_int[main_closest_i][0]; a++)
		shift_12_2_array(tmp_int);
  }

  if(sub_closest_scale_int[0][1] == 0){
	 set_tmp_array(tmp2_int, major_s_int);
	 for(a = 0;a < sub_closest_scale_int[0][0]; a++)
		shift_12_2_array(tmp2_int);
  }else{
	 set_tmp_array(tmp2_int, minor_harmonic_s_int);
	 for(a = 0;a < sub_closest_scale_int[0][0]; a++)
		shift_12_2_array(tmp2_int);
  }

  if(sub2_closest_scale_int[0][1] == 0){
	 set_tmp_array(tmp3_int, major_s_int);
	 for(a = 0;a < sub2_closest_scale_int[0][0]; a++)
		shift_12_2_array(tmp3_int);
  }else{
	 set_tmp_array(tmp3_int, minor_harmonic_s_int);
	 for(a = 0;a < sub2_closest_scale_int[0][0]; a++)
		shift_12_2_array(tmp3_int);
  }

  eliminate_notes();
  eliminate_notes();

  random_i = RANDOM(6);

  tmp_array_p[0] = tmp_int[0][0];
  tmp_array_p[1] = tmp_int[1][0];
  tmp_array_p[2] = tmp_int[2][0];
  tmp_array_p[3] = tmp_int[3][0];
  tmp_array_p[4] = tmp_int[4][0];
  tmp_array_p[5] = tmp_int[5][0];
  tmp_array_p[6] = tmp_int[6][0];
  tmp_array_p[7] = tmp_int[7][0];
  tmp_array_p[8] = tmp_int[8][0];
  tmp_array_p[9] = tmp_int[9][0];
  tmp_array_p[10] = tmp_int[10][0];
  tmp_array_p[11] = tmp_int[11][0];
  tmp_array_p[12] = 0;

  clear_sub_closest();
  add_to_closest(tmp_array_p, sub_closest_scale_int);
  /*
  cout << "stored: " << sub_closest_scale_int[0][0] << ", type: "
		 << sub_closest_scale_int[0][1] << ", " << sub_closest_scale_int[0][2]
		 << endl;
  cout << "stored: " << sub_closest_scale_int[1][0] << ", type: "
		 << sub_closest_scale_int[1][1] << ", " << sub_closest_scale_int[1][2]
		 << endl;
  cout << "stored: " << sub_closest_scale_int[2][0] << ", type: "
		 << sub_closest_scale_int[2][1] << ", " << sub_closest_scale_int[2][2]
		 << endl;
  cout << "stored: " << sub_closest_scale_int[3][0] << ", type: "
		 << sub_closest_scale_int[3][1] << ", " << sub_closest_scale_int[3][2]
		 << endl;
  cout << "stored: " << sub_closest_scale_int[4][0] << ", type: "
		 << sub_closest_scale_int[4][1] << ", " << sub_closest_scale_int[4][2]
		 << endl;
  cout << "stored: " << sub_closest_scale_int[5][0] << ", type: "
		 << sub_closest_scale_int[5][1] << ", " << sub_closest_scale_int[5][2]
		 << endl;
  */
  key_i = sub_closest_scale_int[random_i][0];

  maj3_i = key_i + 4;
  if(maj3_i > 11)
	 maj3_i = maj3_i - 12;
  per5_i = key_i + 7;
  if(per5_i > 11)
	 per5_i = per5_i - 12;

  // Select 2nd,4th,6th or 7th to add //
  random_i = RANDOM(4);

  switch(random_i){
	 case 0: note_to_add_i = key_i + 11;
				break;
	 case 1: note_to_add_i = key_i + 5;
				break;
	 case 2: note_to_add_i = key_i + 9;
				break;
	 case 3: note_to_add_i = key_i + 2;
				break;
  }

  if(note_to_add_i > 11)
	 note_to_add_i = note_to_add_i - 12;

  clear_12_2_array(tmp2_int);

  tmp2_int[key_i][0] = 1;
  tmp2_int[maj3_i][0] = 1;
  tmp2_int[per5_i][0] = 1;
  tmp2_int[note_to_add_i][0] = 1;

  set_base_chord_int(key_i);
}

void scale_analyse_c::shift_12_2_array(int (*array_p)[2]){
  int last_i = array_p[11][0];
  int last2_i = array_p[11][1];

  array_p[11][0] = array_p[10][0];
  array_p[11][1] = array_p[10][1];
  array_p[10][0] = array_p[9][0];
  array_p[10][1] = array_p[9][1];
  array_p[9][0] = array_p[8][0];
  array_p[9][1] = array_p[8][1];
  array_p[8][0] = array_p[7][0];
  array_p[8][1] = array_p[7][1];
  array_p[7][0] = array_p[6][0];
  array_p[7][1] = array_p[6][1];
  array_p[6][0] = array_p[5][0];
  array_p[6][1] = array_p[5][1];
  array_p[5][0] = array_p[4][0];
  array_p[5][1] = array_p[4][1];
  array_p[4][0] = array_p[3][0];
  array_p[4][1] = array_p[3][1];
  array_p[3][0] = array_p[2][0];
  array_p[3][1] = array_p[2][1];
  array_p[2][0] = array_p[1][0];
  array_p[2][1] = array_p[1][1];
  array_p[1][0] = array_p[0][0];
  array_p[1][1] = array_p[0][1];
  array_p[0][0] = last_i;
  array_p[0][1] = last2_i;
}

void scale_analyse_c::set_tmp_array(int (*tmp_array_p)[2],
												int (*scale_array_p)[2]){
  tmp_array_p[11][0] = scale_array_p[11][0];
  tmp_array_p[11][1] = scale_array_p[11][1];
  tmp_array_p[10][0] = scale_array_p[10][0];
  tmp_array_p[10][1] = scale_array_p[10][1];
  tmp_array_p[9][0] = scale_array_p[9][0];
  tmp_array_p[9][1] = scale_array_p[9][1];
  tmp_array_p[8][0] = scale_array_p[8][0];
  tmp_array_p[8][1] = scale_array_p[8][1];
  tmp_array_p[7][0] = scale_array_p[7][0];
  tmp_array_p[7][1] = scale_array_p[7][1];
  tmp_array_p[6][0] = scale_array_p[6][0];
  tmp_array_p[6][1] = scale_array_p[6][1];
  tmp_array_p[5][0] = scale_array_p[5][0];
  tmp_array_p[5][1] = scale_array_p[5][1];
  tmp_array_p[4][0] = scale_array_p[4][0];
  tmp_array_p[4][1] = scale_array_p[4][1];
  tmp_array_p[3][0] = scale_array_p[3][0];
  tmp_array_p[3][1] = scale_array_p[3][1];
  tmp_array_p[2][0] = scale_array_p[2][0];
  tmp_array_p[2][1] = scale_array_p[2][1];
  tmp_array_p[1][0] = scale_array_p[1][0];
  tmp_array_p[1][1] = scale_array_p[1][1];
  tmp_array_p[0][0] = scale_array_p[0][0];
  tmp_array_p[0][1] = scale_array_p[0][1];
}

void scale_analyse_c::add_to_closest(int *array_p, int (*closest_array_p)[3]){
  int a;
  int b;
  int tmp_p[3];

  for(a = 0; a < 12; a++){
	 b = 5;

	 while((b >= 0)&&(array_p[a] > closest_array_p[b][2])){
		tmp_p[0] = closest_array_p[b][0];
		tmp_p[1] = closest_array_p[b][1];
		tmp_p[2] = closest_array_p[b][2];

		closest_array_p[b][0] = a;
		closest_array_p[b][1] = array_p[12];
		closest_array_p[b][2] = array_p[a];

		if(b < 5){
		  closest_array_p[b + 1][0] = tmp_p[0];
		  closest_array_p[b + 1][1] = tmp_p[1];
		  closest_array_p[b + 1][2] = tmp_p[2];
		}

		b--;
	 }
  }
}

void scale_analyse_c::remove_note_arrays(){
  if(first_note_ptr != NULL){
	 if(no_first_notes_int > 1)
		delete [] first_note_ptr;
	 else
		delete first_note_ptr;
  }
  if(last_note_ptr != NULL){
	 if(no_last_notes_int > 1)
		delete [] last_note_ptr;
	 else
		delete last_note_ptr;
  }
}

void scale_analyse_c::clear_12_2_array(int (*array_p)[2]){
  array_p[0][0] = 0;
  array_p[0][1] = 0;
  array_p[1][0] = 0;
  array_p[1][1] = 0;
  array_p[2][0] = 0;
  array_p[2][1] = 0;
  array_p[3][0] = 0;
  array_p[3][1] = 0;
  array_p[4][0] = 0;
  array_p[4][1] = 0;
  array_p[5][0] = 0;
  array_p[5][1] = 0;
  array_p[6][0] = 0;
  array_p[6][1] = 0;
  array_p[7][0] = 0;
  array_p[7][1] = 0;
  array_p[8][0] = 0;
  array_p[8][1] = 0;
  array_p[9][0] = 0;
  array_p[9][1] = 0;
  array_p[10][0] = 0;
  array_p[10][1] = 0;
  array_p[11][0] = 0;
  array_p[11][1] = 0;
}

void scale_analyse_c::clear_scale_check(){
  int current_note_i;

  for(current_note_i = 0; current_note_i < 12; current_note_i++)
	 scale_check_int[current_note_i] = 0;
}

void scale_analyse_c::clear_main_closest(){
  int current_note_i;

  for(current_note_i = 0; current_note_i < 6; current_note_i++)
	 main_closest_scale_int[current_note_i][2] = -100;
}

void scale_analyse_c::clear_sub_closest(){
  int current_note_i;

  for(current_note_i = 0; current_note_i < 6; current_note_i++)
	 sub_closest_scale_int[current_note_i][2] = -100;

  for(current_note_i = 0; current_note_i < 6; current_note_i++)
	 sub2_closest_scale_int[current_note_i][2] = -100;
}

void scale_analyse_c::identify_notes(rhythm_block_c *start_block_p,
													rhythm_block_c *end_block_p){

  int current_note_i;
  int tmp_i;
//  int note_i;
  int next_first_i = 0;
  int next_last_i = 0;
  char d;

  no_first_notes_int = phrase_ptr->phrase()->no_notes() + 1;
  no_last_notes_int = phrase_ptr->phrase()->rLlink()->no_notes() + 1;

  first_note_ptr = new int[no_first_notes_int];
  if(first_note_ptr == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }

  last_note_ptr = new int[no_last_notes_int];
  if(last_note_ptr == NULL){
	 cout << "FATAL ERROR: Cannot allocate memory..." << endl;
	 cin.get(d);
  }

  phrase_ptr->iterator()->set_iterator(start_block_p, start_block_p);

  for(current_note_i = 0; current_note_i < 12; current_note_i++){
	 phrase_notes_int[current_note_i] = 0;
  }

  current_note_i = 0;

  do{
	 do{
		tmp_i = phrase_ptr->iterator()->note_pntr()->note()
				  - current_note_i;

		if((tmp_i%12) == 0){
		  phrase_notes_int[current_note_i] ++;

		  if(phrase_ptr->iterator()->rhythm_block() == start_block_p){
			 first_note_ptr[next_first_i] = current_note_i;
			 next_first_i++;
		  }

		  if(phrase_ptr->iterator()->rhythm_block()
			  == end_block_p){
			 last_note_ptr[next_last_i] = current_note_i;
			 next_last_i++;
		  }

		  current_note_i = 0;
		}
		else
		  current_note_i ++;
	 }while(current_note_i != 0);

	 phrase_ptr->iterator()->iterate(0, 0);

  }while(phrase_ptr->iterator()->note_block() != end_block_p->rRlink());

  /*
  cout << "Notes: "
  << phrase_notes_int[0] << ","
  << phrase_notes_int[1] << ","
  << phrase_notes_int[2] << ","
  << phrase_notes_int[3] << ","
  << phrase_notes_int[4] << ","
  << phrase_notes_int[5] << ","
  << phrase_notes_int[6] << ","
  << phrase_notes_int[7] << ","
  << phrase_notes_int[8] << ","
  << phrase_notes_int[9] << ","
  << phrase_notes_int[10] << ","
  << phrase_notes_int[11] << endl;
  */
}

void scale_analyse_c::initialise_scales(){
  major_s_int[0][0] = 11;
  major_s_int[0][1] = -22;
  major_s_int[1][0] = -30;
  major_s_int[1][1] = 30;
  major_s_int[2][0] = 3;
  major_s_int[2][1] = -6;
  major_s_int[3][0] = -30;
  major_s_int[3][1] = 30;
  major_s_int[4][0] = 6;
  major_s_int[4][1] = -12;
  major_s_int[5][0] = 4;
  major_s_int[5][1] = -8;
  major_s_int[6][0] = -30;
  major_s_int[6][1] = 30;
  major_s_int[7][0] = 8;
  major_s_int[7][1] = -16;
  major_s_int[8][0] = -30;
  major_s_int[8][1] = 30;
  major_s_int[9][0] = 4;
  major_s_int[9][1] = -8;
  major_s_int[10][0] = -30;
  major_s_int[10][1] = 30;
  major_s_int[11][0] = 1;
  major_s_int[11][1] = -2;

  minor_harmonic_s_int[0][0] = 11;
  minor_harmonic_s_int[0][1] = -22;
  minor_harmonic_s_int[1][0] = -30;
  minor_harmonic_s_int[1][1] = 30;
  minor_harmonic_s_int[2][0] = 3;
  minor_harmonic_s_int[2][1] = -6;
  minor_harmonic_s_int[3][0] = 6;
  minor_harmonic_s_int[3][1] = -12;
  minor_harmonic_s_int[4][0] = -30;
  minor_harmonic_s_int[4][1] = 30;
  minor_harmonic_s_int[5][0] = 4;
  minor_harmonic_s_int[5][1] = -8;
  minor_harmonic_s_int[6][0] = -30;
  minor_harmonic_s_int[6][1] = 30;
  minor_harmonic_s_int[7][0] = 8;
  minor_harmonic_s_int[7][1] = -16;
  minor_harmonic_s_int[8][0] = 4;
  minor_harmonic_s_int[8][1] = -8;
  minor_harmonic_s_int[9][0] = 0;
  minor_harmonic_s_int[9][1] = 0;
  minor_harmonic_s_int[10][0] = 2;
  minor_harmonic_s_int[10][1] = -4;
  minor_harmonic_s_int[11][0] = 0;
  minor_harmonic_s_int[11][1] = 0;

  minor_melodic_s_int[0] = 1;
  minor_melodic_s_int[1] = 0;
  minor_melodic_s_int[2] = 1;
  minor_melodic_s_int[3] = 1;
  minor_melodic_s_int[4] = 0;
  minor_melodic_s_int[5] = 1;
  minor_melodic_s_int[6] = 0;
  minor_melodic_s_int[7] = 1;
  minor_melodic_s_int[8] = 1;
  minor_melodic_s_int[9] = 1;
  minor_melodic_s_int[10] = 1;
  minor_melodic_s_int[11] = 1;
}

void scale_analyse_c::compare_scale(int (*scale_array_p)[2],
												int (*closest_array_p)[3]){
  int a;
  int b;
  int c;
//  char d;
//  int start_end_note_assesment_i;
  int tmp_assesment_int[13];
  int assesment_i;


  set_tmp_array(tmp_int, scale_array_p);

  for(a = 0; a < 12; a++){
	 assesment_i = 0;

	 clear_scale_check();

	 for(b = 0; b < 12; b++){
		if((phrase_notes_int[b] * tmp_int[b][0]) != 0){
	     scale_check_int[b] = 1;

		  assesment_i = assesment_i + (phrase_notes_int[b] * tmp_int[b][0]);
		  for(c = 0; c < no_first_notes_int; c++){
			 if(b == first_note_ptr[c]){
				assesment_i = assesment_i + 25;
				assesment_i = assesment_i + (5 * phrase_notes_int[b]);
			 }
		  }
		  for(c = 0; c < no_last_notes_int; c++){
			 if(b == last_note_ptr[c]){
				assesment_i = assesment_i + 50;
				assesment_i = assesment_i + (5 * phrase_notes_int[b]);
			 }
		  }
		}else
		  assesment_i = assesment_i + phrase_notes_int[b] * tmp_int[b][1];
	 }

	 for(c = 0; c < 12; c++){
		if(scale_check_int[c] == 1){
		  assesment_i = assesment_i + tmp_int[c][0];
		}
	 }

	 tmp_assesment_int[a] = assesment_i;
	 shift_12_2_array(tmp_int);
  }
  tmp_assesment_int[12] = scale_array_p[12][0];
  add_to_closest(tmp_assesment_int, closest_array_p);
}

