#include "random.h"
#include "randcont.h"

// Default constructor
random_control_c::random_control_c(){
  ratio_low_int = 25;
  ratio_midl_int = 25;
  ratio_midh_int = 25;
  ratio_high_int = 25;
  no_low_int = 0;
  no_midl_int = 0;
  no_midh_int = 0;
  no_high_int = 0;
}


random_control_c::random_control_c(int ratio_low_i, int ratio_midl_i,
											  int ratio_midh_i, int ratio_high_i){
  ratio_low_int = 100/ratio_low_i;
  ratio_midl_int = 100/ratio_midl_i;
  ratio_midh_int = 100/ratio_midh_i;
  ratio_high_int = 100/ratio_high_i;

#ifndef __linux__
  no_low_int = RANDOM(ratio_low_int);
  no_midl_int = RANDOM(ratio_midl_int);
  no_midh_int = RANDOM(ratio_midh_int);
  no_high_int = RANDOM(ratio_high_int);
#endif

}

int random_control_c::random_num(int max_i, int ratio_low_i, int ratio_midl_i,
											int ratio_midh_i, int ratio_high_i){
//  int a;
  int random_i;

  ratio_low_int = 100/ratio_low_i;
  ratio_midl_int = 100/ratio_midl_i;
  ratio_midh_int = 100/ratio_midh_i;
  ratio_high_int = 100/ratio_high_i;
  no_low_int = RANDOM(ratio_low_int);
  no_midl_int = RANDOM(ratio_midl_int);
  no_midh_int = RANDOM(ratio_midh_int);
  no_high_int = RANDOM(ratio_high_int);

  random_i = random_num(max_i);

  return random_i;
}

int random_control_c::random_num(int max_i){
//  int a;
  int random_i;
  double random_limit_d;
//  int not_accepted_i = 1;
  int change_made_i;

  if(max_i < 0)
	 max_i = 32767;

  if((max_i == 2)||(max_i == 3))
	 random_limit_d = 1;
  else
	 random_limit_d = (max_i)/4.0;

  if(max_i == 1)
	 random_i = 0;
  else do{
	 random_i = RANDOM(max_i);
	 change_made_i = 0;

	 if(random_i < random_limit_d){
		no_low_int++;
		if(no_low_int != ratio_low_int){
		  do{
			 random_i = RANDOM(max_i);
		  }while(random_i < random_limit_d);
		  change_made_i = 1;
		}
		if(no_low_int == ratio_low_int)
		  no_low_int = 0;
	 }
	 if((random_i >= random_limit_d)&&(random_i < (2 * random_limit_d))){
		no_midl_int++;
		if(no_midl_int != ratio_midl_int){
		  do{
			 random_i = RANDOM(max_i);
		  }while((random_i >= random_limit_d)
				  &&(random_i < (2 * random_limit_d)));
		  change_made_i = 1;
		}
		if(no_midl_int == ratio_midl_int)
		  no_midl_int = 0;
	 }
	 if((random_i >= (2 * random_limit_d))
			  &&(random_i < (3 * random_limit_d))){
		no_midh_int++;
		if(no_midh_int != ratio_midh_int){
		  do{
			 random_i = RANDOM(max_i);
		  }while((random_i >= (2 * random_limit_d))
				  &&(random_i < (3 * random_limit_d)));
		  change_made_i = 1;
		}
		if(no_midh_int == ratio_midh_int)
		  no_midh_int = 0;
	 }
	 if(random_i >= (3 * random_limit_d)){
		no_high_int++;
		if(no_high_int != ratio_high_int){
		  do{
			 random_i = RANDOM(max_i);
		  }while(random_i >= (3 * random_limit_d));
		  change_made_i = 1;
		}
		if(no_high_int == ratio_high_int)
		  no_high_int = 0;
	 }
  }while(change_made_i == 1);

  random_i = random_i + 1;

  return random_i;
}

