#ifndef _iterator_h
#define _iterator_h

// This file is an object called block iterator //
// It can iterate through rhythm and note block paths //
// 11 feb 1998 Julian Sweeting //

class rhythm_block_c;
class note_block_c;
class note_c;

class block_iterator_c{
  public:
	 block_iterator_c();
	 void iterate(int direction_i, int next_block_type_i);
		// direction: 0 = right, 1 = left block_type: 0 = note, 1 = rhythm //
	 rhythm_block_c *set_iterator
					  (rhythm_block_c *rhythm_block_p, note_block_c *note_block_p);
	 void update();
	 int no_notes(){return no_notes_current_rblock_int;}
	 int note_in(){return note_in_current_rblock_int;}
	 rhythm_block_c *rhythm_block(){return current_rhythm_block_ptr;}
	 note_block_c *note_block(){return current_note_block_ptr;}
	 note_c *note_pntr(){return current_note_ptr;}
  private:
	 void iterate_to_main_block(int direction_i);
		// 0 = right from anywhere, 1 = current from anywhere, //
		// 2 = left from rhythm block //

	 void iterate_to_note_block(int direction_i);
		// 0 = right (within non rhythm blocks), 1 = left from main block, //
		//	2 = left (within non rhythm blocks) //

	 note_c *current_note_ptr;
	 note_block_c *current_note_block_ptr;
	 rhythm_block_c *current_rhythm_block_ptr;
	 int no_notes_current_rblock_int;
	 int note_in_current_rblock_int;
};

#endif
