#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/soundcard.h>
#include <math.h>

#define ABS(x) ((x < 0) ? (-x) : (x))
#define MAX(A,B)  ( (A) > (B) ? (A) : (B)  )

/*
    This version of soundio.c is specific for use on Linux/USS.

	--Tim Stilson, 09/96

	based on sgio.C by Doug Scott, 10/95
*/

int audio_fd;

long bufsize;   
int lookaheadbuffers = 8;  // number of lookahead buffers

int
init_sound(float sr,int chans)
{
	long pvbuf[2];
	int nbuf;

    char DEVICE_NAME[100];
    int format;
    int stereo;     /* 0=mono, 1=stereo */
    int stereoset;
    int speed;
	int BUFFER_SIZE_LOG;
	int fragsize;

	BUFFER_SIZE_LOG = (int)(log10((double)RT_BUFFER_SIZE)/log10(2.0));

	if (chans > 2)
	{
		perror("unspported # of output channels");
		exit(-1);
	}

	if (chans == 2)
		stereo = 1;
	else
		stereo = 0;


    strcpy(DEVICE_NAME,"/dev/dspW");

    if ((audio_fd = open(DEVICE_NAME, O_WRONLY, 0)) == -1)
    { /* Opening device failed */
        printf("\nopen failed, device: %s\n",DEVICE_NAME);
        exit(-1);
    }

	/* make output queue twice the size of our buffer */
	nbuf = (chans == 2) ? lookaheadbuffers : lookaheadbuffers/2;
	bufsize = RT_BUFFER_SIZE * nbuf;

    /*fragsize = 0xffff0000 + BUFFER_SIZE_LOG;*/
    fragsize = (nbuf << 16) + BUFFER_SIZE_LOG;
    if (ioctl(audio_fd, SNDCTL_DSP_SETFRAGMENT, &fragsize))
    {
        close(audio_fd);
        perror("error setting buffer size");
        exit(-1);
    }

    format = AFMT_S16_LE;
    if (ioctl(audio_fd, SNDCTL_DSP_SETFMT, &format)==-1)
    { /* Fatal error */
        close(audio_fd);
        perror("SNDCTL_DSP_SETFMT error");
        exit(-1);
    }

    if (format != AFMT_S16_LE)
    {
        close(audio_fd);
        perror("soundcard doesn't support my format");
        exit(-1);
    }

	stereoset = stereo;
    if (ioctl(audio_fd, SNDCTL_DSP_STEREO, &stereoset)==-1)
    { /* Fatal error */
        close(audio_fd);
        perror("SNDCTL_DSP_STEREO");
        exit(-1);
    }

    if (stereoset != stereo)
    {
        close(audio_fd);
        perror("the sound card did not set correct stereo mode");
        exit(-1);
    }   


	speed = (int)sr;
    if (ioctl(audio_fd, SNDCTL_DSP_SPEED, &speed)==-1)
    { /* Fatal error */
        close(audio_fd);
        perror("SNDCTL_DSP_SPEED");
        exit(-1);
    }

    if (ABS(speed-sr)>100)
    {
        close(audio_fd);
        perror("The device doesn't support the requested speed.");
        exit(-1);
    }


/* TS: I don't know if/how this converts to USS */
	/* tell port to accept refill at buffers - 1 */
	/* ALsetfillpoint(audio_port,RT_BUFFER_SIZE * (lookaheadbuffers - 1));  */
	return(0);
}

void shuddup()
{
	if(audio_fd) close(audio_fd);
	audio_fd=0;
}

int
playbuf(short *buf,int bufsize_inbytes)
{
	int len;

    if ((len = write(audio_fd, buf, bufsize_inbytes)) == -1)
	{
		shuddup();
		perror("audio write error");
		return(-1);
	}
    return(0);
}
