/*******************************************/
/*  NeXT Sound File Output Class,          */
/*  by Perry R. Cook, 1995-96              */ 
/*  This version opens a mono NeXT .snd    */
/*  file 16bit data at 22KHz, and          */
/*  pokes buffers of samples into it.      */
/*******************************************/

#include "SndWvOut.h"

/********  NeXT Soundfile Header Struct   *******/
struct headerform {
    char pref[4];
    long hdr_length;
    long file_length;
    long mode;
    long samp_rate;
    long num_channels;
    char comment[1024];
};

SndWvOut :: SndWvOut(char *fileName)
{
    struct headerform hdr = {".sn",28,0,3,(long) SRATE,1,"TK"};
    hdr.pref[3] = 'd';

    fd = fopen(fileName,"wb");
    if (!fd)   {
	printf("Couldn't create soundfile %s  !!!!!!!!\n",fileName);
	exit(0);
    }
    fwrite(&hdr,4,7,fd);
    counter = 0;
    totalCount = 0;
}

SndWvOut :: ~SndWvOut()
{
    MY_FLOAT temp;
    fwrite(data,2,counter,fd);
    fseek(fd,8,SEEK_SET);
    fwrite(&totalCount,4,1,fd);
    fclose(fd);
    temp = (double) totalCount * ONE_OVER_SRATE;
    printf("%f Seconds Computed\n",temp);
}

long SndWvOut :: getCounter()
{
    return totalCount;
}

void SndWvOut :: tick(MY_FLOAT sample)
{

    data[counter++] = (short) (sample * 32000.0);
    totalCount += 1;
    if (counter == SND_BUFFER_SIZE) {
	fwrite(data,2,SND_BUFFER_SIZE,fd);
	counter = 0;
    }
}
