double phonGains[32][2] =
     {{1.0,0.0},    // eee
      {1.0,0.0},    // ihh
      {1.5,0.0},    // ehh
      {1.0,0.0},    // aaa
       
      {0.5,0.0},    // ahh
      {0.5,0.0},    // aww
      {0.5,0.0},    // ohh
      {0.5,0.0},    // uhh
      
      {0.5,0.0},    // uuu
      {0.15,0.0},    // ooo
      {0.15,0.0},    // rrr
      {6.0,0.0},    // lll

      {1.0,0.0},    // mmm
      {1.0,0.0},    // nnn
      {1.0,0.0},    // nng
      {1.0,0.0},    // ngg
      
      {0.0,1.0},    // fff
      {0.0,1.0},    // sss
      {0.0,1.0},    // thh
      {0.0,1.0},    // shh
      
      {0.0,0.2},    // xxx
      {0.0,0.003},  // hee
      {0.0,0.001},  // hoo
      {0.0,0.002},  // hah
      
      {1.0,0.4},    // bbb
      {4.0,0.1},    // ddd
      {1.0,0.4},    // jjj
      {1.0,0.4},    // ggg

      {1.0,0.1},    // vvv
      {1.0,0.1},    // zzz
      {1.0,0.1},    // thz
      {1.0,0.1}     // zhh
};         

double phonParams[32][4][3] =
    {{  { 273,0.996,   0},       // eee (beet)
        {2086,0.945, -16}, 
        {2754,0.979, -12}, 
        {3270,0.440, -17}},
     {  { 385,0.987,   0},       // ihh (bit)
        {2056,0.930, -20},
        {2587,0.890, -20}, 
        {3150,0.400, -20}},
     {  { 515,0.977,   0},       // ehh (bet)
        {1805,0.810, -10}, 
        {2526,0.875, -10}, 
        {3103,0.400, -13}},
     {  { 773,0.950,   0},       // aaa (bat)
        {1676,0.830,  -6},
        {2380,0.880, -20}, 
        {3027,0.600, -20}},
     
     {  { 770,0.950,   0},       // ahh (father)
        {1153,0.970,  -3},
        {2450,0.780, -20},
        {3140,0.800, -32}},
     {  { 637,0.910,   0},       // aww (bought)
        { 895,0.900,  -3},
        {2556,0.950, -17},
        {3070,0.910, -20}},
     {  { 637,0.910,   0},       // ohh (bone)  NOTE::  same as aww (bought)
        { 895,0.900,  -3},
        {2556,0.950, -17},
        {3070,0.910, -20}},
     {  { 561,0.965,   0},       // uhh (but)
        {1084,0.930, -10}, 
        {2541,0.930, -15}, 
        {3345,0.900, -20}},
    
     {  { 515,0.976,   0},       // uuu (foot)
        {1031,0.950,  -3},
        {2572,0.960, -11},
        {3345,0.960, -20}},
     {  { 349,0.986,   0},       // ooo (boot)
        { 918,0.940, -10},
        {2350,0.960, -17},
        {2731,0.950, -23}},
     {  { 394,0.959,   0},       // rrr (bird)
        {1297,0.780,  -6},
        {1441,0.980,  -6},
        {2754,0.950, -30}},
     {  { 462,0.940,   0},       // lll (lull)
        {2754,0.900, -30},
        {3406,0.100, -30},
        {3755,0.100, -30}},
     
     {  { 265,0.987,   0},       // mmm (mom)
        {1176,0.940, -22},
        {2352,0.970, -20},
        {3277,0.940, -31}},
     {  { 204,0.980,   0},       // nnn (nun)
        {1570,0.940, -15},
        {2481,0.980, -12},
        {3133,0.800, -30}},
     {  { 204,0.980,   0},       // nng (sang)    NOTE:: same as nnn
        {1570,0.940, -15},
        {2481,0.980, -12},
        {3133,0.800, -30}},
     {  { 204,0.980,   0},       // ngg (bong)    NOTE:: same as nnn
        {1570,0.940, -15},
        {2481,0.980, -12},
        {3133,0.800, -30}},
     
     {  {1000,0.300, -10},       // fff
        {2800,0.860, -10},
        {7425,0.740,   0},
        {8140,0.860,   0}},
     {  {2000,0.700, -20},       // sss
        {5257,0.750, -15},
        {7171,0.840,  -3}, 
        {9000,0.900,   0}},
     {  { 100,0.900,   0},       // thh
        {4000,0.500, -20},
        {5500,0.500, -15},
        {8000,0.400, -20}},
     {  {2693,0.940,   0},       // shh
        {4000,0.720, -10},
        {6123,0.870, -10},
        {7755,0.750, -18}},

     {  {1000,0.300, -10},       // xxx           NOTE:: Not Really Done Yet
        {2800,0.860, -10},
        {7425,0.740,   0},
        {8140,0.860,   0}},
     {  { 273,0.996,   0},       // hee (beet)    (noisy eee)
        {2086,0.945, -16}, 
        {2754,0.979, -12}, 
        {3270,0.440, -17}},
     {  { 349,0.986,   0},       // hoo (boot)    (noisy ooo)
        { 918,0.940, -10},
        {2350,0.960, -17},
        {2731,0.950, -23}},
     {  { 770,0.950,   0},       // hah (father)  (noisy ahh)
        {1153,0.970,  -3},
        {2450,0.780, -20},
        {3140,0.800, -32}},
     
     {  {2000,0.700, -20},       // bbb           NOTE:: Not Really Done Yet
        {5257,0.750, -15},
        {7171,0.840,  -3}, 
        {9000,0.900,   0}},
     {  { 100,0.900,   0},       // ddd           NOTE:: Not Really Done Yet
        {4000,0.500, -20},
        {5500,0.500, -15},
        {8000,0.400, -20}},
     {  {2693,0.940,   0},       // jjj           NOTE:: Not Really Done Yet
        {4000,0.720, -10},
        {6123,0.870, -10},
        {7755,0.750, -18}},
     {  {2693,0.940,   0},       // ggg           NOTE:: Not Really Done Yet
        {4000,0.720, -10},
        {6123,0.870, -10},
        {7755,0.750, -18}},
     
     {  {2000,0.700, -20},       // vvv           NOTE:: Not Really Done Yet
        {5257,0.750, -15},
        {7171,0.840,  -3}, 
        {9000,0.900,   0}},
     {  { 100,0.900,   0},       // zzz           NOTE:: Not Really Done Yet
        {4000,0.500, -20},
        {5500,0.500, -15},
        {8000,0.400, -20}},
     {  {2693,0.940,   0},       // thz           NOTE:: Not Really Done Yet
        {4000,0.720, -10},
        {6123,0.870, -10},
        {7755,0.750, -18}},
     {  {2693,0.940,   0},       // zhh           NOTE:: Not Really Done Yet
        {4000,0.720, -10},
        {6123,0.870, -10},
        {7755,0.750, -18}}
};

char phonemes[32][4] = 
    {"eee","ihh","ehh","aaa",
     "ahh","aww","ohh","uhh",
     "uuu","ooo","rrr","lll",
     "mmm","nnn","nng","ngg",
     "fff","sss","thh","shh",
     "xxx","hee","hoo","hah",
     "bbb","ddd","jjj","ggg",
     "vvv","zzz","thz","zhh"};
