#ifndef _SDLLBase_H
#define _SDLLBase_H

#include "JSeqItem.h"

#include "assert.h"

/// Could be more absract but maybe we want to process real fast ?

class SDLLNode:public JSeqItem
{

public:

  SDLLNode(void *ptr,SDLLNode *prev,SDLLNode *next)
    :_next(next),_prev(prev),_ptr(ptr){;}

  SDLLNode * _next;
  SDLLNode * _prev;
  void     * _ptr;

};

/// This allows you to create a list out of a segement of another list.

class SDLLDelimiter
{

  friend class SDLLIteratorBase;
public:


  SDLLDelimiter():_first(0),_last(0) {;}

protected:

  SDLLNode *_first;
  SDLLNode *_last;
};

///
class SDLListBase:public SDLLDelimiter
{
public:
  ///
  SDLListBase(){;}
protected:
  ///
  void _addToEnd(void *ptr);
  ///
  void _addToStart(void *ptr);
  ///
  void _insertBefore(SDLLNode *node,void *ptr);
  ///
  bool _contains(void *ptr) const;

  int  _find(const void *ptr) const ;

  void * _at(int i);
public:
  ///
  void discardHead();
  int  count() const;
};


///
class SDLLIteratorBase
{
public:
  ///
  SDLLIteratorBase(SDLListBase *list)
    :_node(list->_first)
  {;}

public:
  ///
  void     advance()  { if (_node != 0 ) _node= _node->_next;}
  ///
  SDLLNode *node()    { return _node; }
protected:
  ///
  SDLLNode *_node;
};

///
template <class T>
class SDLList:public SDLListBase
{
public:
  /// Put at the end.
  void append(T * ptr) {_addToEnd(ptr);}

  /// Put at the start.
  void prepend(T * ptr) {_addToStart(ptr);}

  /// Don't care.
  void add(T *ptr) { _addToStart(ptr);}

  T *at(int i) { return (T *)_at(i); }
  ///
  bool contains(const T *ptr) const { return _contains((void *)ptr);}

  int  find(const T *ptr) const { return _find(ptr);}

//   /// Clear the list and delete any things in it ?
  void clear(bool deleteThings)
    {
      while( _first != 0 )
	{
	  SDLLNode *tmp = _first;
	  _first=_first->_next;
	  if (deleteThings) delete ((T *)(tmp->_ptr));
	  delete tmp;
	}
    }

  /// delete current item and fix the list.
  void clearItem(T * victim,
		 bool deleteThing)
  {
    SDLLNode *node=_first;
    while( node != 0 )
      {
	T *item= (T *)(node->_ptr);
	if (item == victim) {
	  if (deleteThing) delete victim;
	  if (node == _first) {
	    _first=_first->_next;
	    if (_first != 0) _first->_prev=0;
	    else _last=0;
	    delete node;
	  }  else if (node == _last) {
	    _last=_last->_prev;
	    if (_last != 0) _last->_next=0;
	    delete node;
	  } else {
	    node->_prev->_next = node->_next;
	    node->_next->_prev = node->_prev;
	    delete node;
	  }
	  return;
	}
	node=node->_next;
      }
  }
  
  
  const T * itemAfter(const T *me) const
  {
    assert( me != 0 );
    
    SDLLNode *node=_first;
    while( node != 0 )  {
      T *item= (T *)(node->_ptr);
      if (item == me) {
	if ( node->_next != 0 ) 
	  return (const T *) (node->_next->_ptr);
	else
	  return (const T *) (_first->_ptr);
      }
      node=node->_next;
    }
    
    assert(0);
    return 0;
  }


  const T * itemBefore(const T *me) const
  {
    assert( me != 0 );
    
    SDLLNode *node=_last;

    while( node != 0 )  {
      T *item= (T *)(node->_ptr);
      if (item == me) {
	if ( node->_prev != 0 ) 
	  return (const T *) (node->_prev->_ptr);
	else
	  return (const T *) (_last->_ptr);
      }
      node=node->_prev;
    }
    
    assert(0);
    return 0;
  }

  ///
  T * first() const
  {
    if (_first == 0) return 0; 
    return (T *)(_first->_ptr);
  }

  ///
  T * last() const 
  {     
    if (_last == 0) return 0; 
    return (T *)(_last->_ptr);
  }

};


///
template <class T>
class SDLLIterator:public SDLLIteratorBase
{
public:
  ///
  SDLLIterator(SDLList<T> *list)
    :SDLLIteratorBase(list)
  {;}

public:

  ///
  T * peek() const 
  {
    if (_node == 0 ) return 0;
    return (T *)(_node->_ptr);
  }

  ///
  T * next() 
  {
    if (_node == 0 ) return 0;
    T * item=(T *)(_node->_ptr);
    _node=_node->_next;
    return item;
  }

  
  bool seek(T *t) {
    T *tt;
    while( (tt=next()) != 0 ) {
      if ( tt==t ) return true;
    }
    return false;
  }
    
};


#endif






