#include "JSweepSequencer.h"
#include "jam/JSweepGesture.h"
#include "jam/JPlayer.h"

JSweepSequencer::JSweepSequencer(const JSweepGesture *sweep,JPlayer *player)
  :_sweep(sweep),
   _player(player),
   _next(sweep->start()),
   _val(sweep->startValue())
{

  assert(_player != 0);

  double diff = sweep->endValue() - sweep->startValue();
  
  if (diff > 0) {
    _delta = (sweep->end() - sweep->start()).rep() / diff;
    _inc =  1;
  }  else if (diff < 0) {
    _delta = - (sweep->end() - sweep->start()).rep() / diff;
    _inc = -1;
  } else {
    _delta = sweep->end() - sweep->start();
    _inc = 0;
  }
}

JBeat
JSweepSequencer::nextBeat()
{
  return _next;
}

JBeat 
JSweepSequencer::gotoBeat(const JBeat &when)
{
  if (when <= _sweep->start()) {
    _next=_sweep->start();
  } else if (when < _sweep->end()) {
    _next=when;
  } else {
    _next=JBeat::endOfTime();
  }

  double tmp = ( when - _sweep->start() ).rep() * _sweep->endValue() +
    ( _sweep->end() - when ).rep() * _sweep->startValue();
  
  _val = (int)(tmp / ( _sweep->end() - _sweep->start() ).rep());
    
  return _next;

}

JBeat 
JSweepSequencer::execute()
{
  if (_next < _sweep->end()) {
    JMidiOutEvent e =_sweep->event();
    e.setValue(_val);
    ((JHandler <JMidiOutEvent, void> *)_player)->
      handle(e);
    _next += _delta ;
    _val  += _inc ;
  } 
  return _next;
}





