#include <iostream.h>
#include "JLoopPhraseSequencer.h"
#include "JPhraseSequencer.h"
#include "jam/JPhrase.h"

JLoopPhraseSequencer::JLoopPhraseSequencer(const JPhrase *phrase,
					   JPlayer *player)
  :_beat(JBeat::endOfTime()),
   _phrase((JPhrase *)phrase),
   _left(phrase->loopLeft()),
   _right(phrase->loopRight()),
   _count(0),
   _nLoop(phrase->loopCount()),
   _myOffset(0),
   _period(phrase->loopRight() - phrase->loopLeft()),
   _sequencer(0)
{

  if (_period <= 0) {
    _beat=JBeat::endOfTime();
    return;
  }

  _sequencer = new JPhraseSequencer(phrase,player);
  _beat = _sequencer->nextBeat();
}



JBeat
JLoopPhraseSequencer::execute()
{


  if (_sequencer == 0 ) {
    _beat = JBeat::endOfTime();
    return _beat;
  }

  assert(_sequencer != 0);

  JBeat nextBeat = _sequencer->execute();

  if ( _count < _nLoop-1 ) {
    if ( nextBeat > _right ) {
      _count++;
      _myOffset +=  _period;

      _sequencer->gotoBeat(_left);
      nextBeat = _sequencer->nextBeat();
    }
  }

  _beat = nextBeat + _myOffset;

  return _beat;
}


JLoopPhraseSequencer::~JLoopPhraseSequencer()
{
    delete _sequencer;
}


JBeat 
JLoopPhraseSequencer::gotoBeat(const JBeat &when)
{

  if (_sequencer == 0 ) {
    _beat = JBeat::endOfTime();
    return _beat;
  }

  assert(_sequencer != 0);

  if (_period <= 0) {
    _beat=JBeat::endOfTime();
    return _beat;
  }

  if ( when < _left ) {
    _count=0;
    _sequencer->gotoBeat(when);
    _beat = _sequencer->nextBeat();
  } else {

    _count = (int)((when - _left).rep() / _period.rep());
    
    if ( _count >= _nLoop) {
      _beat = JBeat::endOfTime();
    } else {
      _myOffset = _count * _period.rep();
      _sequencer->gotoBeat(when - _myOffset);
      _beat = _sequencer->nextBeat();
    }
  }

  return _beat;
}














