#include "dirview.h"
#include "QJSBKItem.h"
#include <qdir.h>
#include <qfile.h>
#include <qfileinf.h>

RCSTAG("$Id: dirview.cpp,v 1.4 1998/01/17 23:26:11 agulbra Exp $");


Directory::Directory( Directory * parent, const char * filename )
    : QListViewItem( parent ), f(filename )
{
    p = parent;
    readable = TRUE;
}


Directory::Directory( QListView * parent,const char * filename ) 
    : QListViewItem( parent ), f(filename)
{
    p = 0;
    readable = TRUE;
}


void Directory::setOpen( bool o )
{
    if ( o && (childCount() == 0) ) {
	QString s( fullName() );
	QDir thisDir( s );
	if ( !thisDir.isReadable() ) {
	    readable = FALSE;
	    return;
	}

	const QFileInfoList * files = thisDir.entryInfoList();
	if ( files ) {
	    QFileInfoListIterator it( *files );
	    QFileInfo * f;
	    while( (f=it.current()) != 0 ) {
	      
		++it;
		if (f->fileName() == "." || f->fileName() == "..") {
		} else if ( f->isDir() ){
		    new Directory( this, f->fileName() );
		} else {
		  if (f->isFile()) {
		    if ( f->extension().lower() == "sbk" ||
			 f->extension().lower() == "sf2" )
		      new QJSBKItem( this, thisDir.absFilePath(f->fileName()));
		  }
		}
	    }
	}
    }
    QListViewItem::setOpen( o );
}


void Directory::setup()
{
    setExpandable( TRUE );
    QListViewItem::setup();
}


QString Directory::fullName()
{
    QString s;
    if ( p ) {
	s = p->fullName();
	s.append( f.name() );
	s.append( "/" );
    } else {
	s = f.name();;
    }
    return s;
}


const char * Directory::text( int column ) const
{
    if ( column == 0 )
	return f.name();
    else if ( readable )
	return "Directory";
    else
	return "Unreadable Directory";
}
