#ifndef _QJScorePainter_H
#define _QJScorePainter_H

#include <qrect.h>
#include "QJDrawComponents.h"
#include "jam/JScorePainter.h"
#include "rep/JBeat.h"
#include "rep/JNoteStyle.h"
#include "rep/JStave.h"


class QJDraw;
class JStave;
class JStaveToY;
class JBeatToX;
class JDuration;
class JBeatList;
class JStave;
class JFocus;
class JMeter;

class QJScorePainter : public JScorePainter
{

public:
  ///

  ///
  QJScorePainter(QPaintDevice * paintDevice,
		 QPixmap      * backingstore,
		 const JStave * stave,
		 const JBeatToX  *   beatToX,
		 const JStaveToY  *  staveToY,
		 QJDrawComponents * components);

  virtual ~QJScorePainter();
  
  /// Clear everything !!!
  void clear();


  /// Wipe area from --- till 
  /// If side effects then you may adjust from and till.
  void clear(JLRRep);



  //! Dar a bar line

  bool drawBar(JBeat beat,
	       int    num,
	       JStyle style=NORMAL);
  

  //! Draw note return TRUE is it can FALSE if it is too stupid

  bool drawNote(JBeat beat,
		JDuration duration,
		int pitch,
		JStyle style=NORMAL,
		JNoteStyle noteStyle=DEFAULT);


  bool drawEvent(JBeat beat);

  bool drawRest(JBeat beat,
		JDuration duration,
		int pitch=71,
		JStyle style=NORMAL);


  // TODO Hmmmmmm ???

  void update();

  void setName(const char *name) { _name=name; }

  void  setCursorAt(JBeat ,int);
  void  cursorOn(bool on);
  void  assertCursor();

private:

  void setStyle(JStyle style);
  void addToUpdate(const QRect &rect);
  void updateDone();
  ///
  void drawStaff();
  void drawClef();
  void drawStaff(int left,int right);
  void drawName();


  //! Draw the cursor at current position 
  void drawCursor();

  //! Erase the cursor at current position 
  void eraseCursor();



  QPaintDevice *       _paintDevice;
  QPixmap *            _pixmap;
  const JStave *       _stave;
  const JStaveToY *    _staveToY;
  QJDrawComponents *   _components;
  int                  _leftAdjust;
  int                  _rightAdjust;
  const    char *      _name;
  QRect                _updateRect;
  bool                 _needUpdate;
  JStyle               _style;
  QPainter  *          _painter;

  // cursor
  const QJDraw *  _cursorDraw;
  int             _cursorX;
  int             _cursorY;
  JBeat           _cursorBeat;
  JStyle          _cursorStyle;
  bool            _cursorOn;
  int             _cursorPitch;

  int             _lastPitch;     

  const JBeatToX *      _beatToX;
};

#endif






