#ifndef _JTimer_H
#define _JTimer_H

#include "JTime.h"
#include "assert.h"

class JTimer
{
protected:
  JTimer();
public:
  static JTimer * the() { assert(_the!=0) ; return _the; }
  virtual ~JTimer(){}
  virtual void   setNow(const JBeat &time)=0; 
  virtual void   setTempo(double bpm)=0;
  virtual double tempo() const =0;
  virtual JBeat  beatNow() const =0;
  virtual void   stop()=0;
  virtual void   start()=0;
  virtual bool   isStoped()const =0;

private:
  static JTimer *_the;
};


#endif
