#ifndef _JScorePainter_H
#define _JScorePainter_H

#include "rep/JStyle.h"
#include "rep/JNoteStyle.h"
#include "rep/JLRRep.h"

class JBeat;
class JDuration;
class JStaveToScreen;
class JScoreCursor;
class JBeatList;
class JFocus;

class JScorePainter
{

public:


  JScorePainter(){}
  
  virtual ~JScorePainter(){;}


  /// Clear everything !!!
  virtual void clear()=0;


  /*! 
    Wipe area from --- till 
    May adjust from and till if required. 
   */
  virtual void clear(JLRRep)=0;

  //! Dar a bar line
  virtual bool drawBar(JBeat beat,
		       int   num,
		       JStyle style=NORMAL)=0;
  

  //! Draw event return TRUE is it can FALSE if it is too stupid
  virtual bool drawNote(JBeat beat,
			JDuration duration,
			int   pitch,
			JStyle style=NORMAL,
			JNoteStyle noteStyle=DEFAULT)=0;

  virtual bool drawEvent(JBeat beat)=0;


  virtual bool drawRest(JBeat beat,
			JDuration duration,
			int   pitch=71,
			JStyle style=NORMAL)=0;


  virtual void setName(const char *name)=0;

  /// Really display things now. (So you can cache if you want to).

  virtual void update()=0;

  virtual void setCursorAt(JBeat  beat,int pitch)=0;

  virtual void cursorOn(bool on)=0;

//   const JFocus *focus() const { return _focus; }

// protected:
//    const JFocus *    _focus; 

};



#endif











