#ifndef _JScheduler_H
#define _JScheduler_H

#include "JTime.h"
#include "assert.h"

class JTimerClient;

class JScheduler
{

protected:
  ///
  JScheduler(); /// purely static class
  
public:
  static JScheduler * the() { assert(_the!=0) ; return _the; }
  virtual ~JScheduler(){}
  virtual void  launch(JTime slice)=0;
  virtual void  setSliceClient(JTimerClient *client)=0;
  virtual void  setAlarmClient(JTimerClient *client)=0;
  virtual void  setAlarmAt(const JBeat &when)=0;
private:
  static JScheduler *_the;
};

#endif






