#ifndef _JPhrase_H
#define _JPhrase_H

#include "JSequence.h"
#include "JGesture.h"
#include "JGestureList.h"
#include "JPhraseUpdate.h"
#include "base/JOSTemplate.h"
#include "JHandle.h"

class JPlayer;
class JTrack;
class JPhraseRep;
class JPhraseController;
class JPart;

class JPhrase:public JHandle,
	      public virtual JSequence,
	      public JSubject<JPhraseUpdate,void>
{

friend class JPhraseController;
friend JTrack;
  JPhrase(JPlayer *player,JTrack *track,JPart *part,JGestureList *gl=0);

public:

  /// ME
  ~JPhrase();
  JPhrase *       clone(JTrack *track);
  JSequencer *    createSequencer(JPlayer *) const;
  JNotator   *    createNotator(JScorePainter *) const;



  JPlayer *       player() { return _player;}
  JTrack *        track() { return _track; }
  const JTrack *  track() const { return _track; }
  
  void  setController(JPhraseController *cntrl) { _controller = cntrl; }
  JPhraseController * controller();
  const JPhraseController * controller() const;


  JPhraseRep *  rep() ;

  bool          write(ostream &) const;
  bool          read(JReader &);

  // Loopable
  void          setLoopLeft(JBeat left);
  void          setLoopRight(JBeat right);
  void          setLoopCount(int loops);

  JBeat         loopLeft() const;
  JBeat         loopRight() const;
  int           loopCount() const;
  
  void          update();

  const char *  name() const{ return "Phrase";}

  // For internal use.
  JGestureList *       gestureList() { return _gestureList;}
  const JGestureList * gestureList() const { return _gestureList;}
  void            appendGesture(JGesture *);
  void            insertGesture(JGesture *);

protected:

  JPlayer  *          _player;
  JTrack *            _track;
  JPart *             _part;
  JGestureList *      _gestureList;
  JPhraseController * _controller;

  JBeat        _loopLeft;
  JBeat        _loopRight;
  int          _loopCount;


  JPhraseUpdate       _update;

};


#endif

