#include <iostream.h>

#include "JNoteGesture.h"
#include "seq/JNoteSequencer.h"
//#include "JNoteNotator.h"
#include "rep/JReader.h"

JNoteGesture::JNoteGesture(JBeat b,JDuration d,int pitch,int vel)
  :JGesture(b),
   _pitch(pitch),
   _vel(vel),
   _d(d)
{
};

JGesture *
JNoteGesture::clone() const
{
  return new JNoteGesture(_start,_d,_pitch,_vel);
};



JSequencer *
JNoteGesture::createSequencer(JPlayer *p) const
{
  return new JNoteSequencer(this,p);
}

bool
JNoteGesture::tweak(double val,int index)
{

  int ival = (int)val;

  switch(index) {
  case 0:
    _pitch = (_pitch+ival)%128;
    return true;

  case 1:
    _vel  += ival;
    if (_vel > 127) _vel=127;
    if (_vel < 0  ) _vel=0;
    return true;

  default:
    return false;
  }
}

const char **
JNoteGesture::tweakNames() const
{
  static const char *names[]={"Pitch","Velocity"};
  return names;

}

bool
JNoteGesture::write(ostream &out) const
{
  out << typeName() 
      << " " <<  _start << " " << _pitch << " " <<  _vel << " "<<  _d;

  return !out.fail();
}


bool
JNoteGesture::read(JReader &in)
{
  in.getBeat(_start);
  in.getInt(_pitch);
  in.getInt(_vel);
  in.getDuration(_d);
  return in.fail();
}


