#include "JMidiFileProcessor.h"
#include <stdio.h>

extern "C" {
 MidiEvent *ReadMidiFile(FILE *fp, MidiInfo *header);
}

JMidiFileProcessor::JMidiFileProcessor(const char *filename)
{
  memcpy(&_glinfo, &gl_default, sizeof(_glinfo));
  _glinfo.chorus = _glinfo.reverb = -1; /* uninitialized */

  _fp = fopen(filename,"r");

  if (_fp == 0) { _fail=true; return;}

  _ev = ReadMidiFile(_fp, &_glinfo);
  if (_ev == NULL) { _fail=true; return; }

  printf("#midievents %d\n", _glinfo.nlists);
  printf("#drumflag 0x%x\n", _glinfo.drumflag);
  printf("#midimode %d\n", _glinfo.midi_mode);
  printf("#multipart %d\n", _glinfo.multi_part);

  if (_glinfo.chorus >= 0)
    printf("#chorus %d\n", _glinfo.chorus);
  if (_glinfo.reverb >= 0)
    printf("#reverb %d\n", _glinfo.reverb);
  if (_glinfo.nlists > 0)
    printf("#totaltime %d\n", _ev[_glinfo.nlists-1].csec);
  else
    printf("#totaltime 0\n");

}

bool 
JMidiFileProcessor::processFile()
{
	initialize();

	int i;

	for (i = 0; i < _glinfo.nlists; i++) {
	  processEvent(&_ev[i]);
	}
	return true;
}


bool 
JMidiFileProcessor::isDrumChannel(int ch)
{
  return (_glinfo.drumflag & (1 << ch) ) != 0;
}

