#include "JFocus.h"
#include "JComposition.h"
#include "JPart.h"
#include "JPhrase.h"
#include "JPlayer.h"


JFocus::JFocus(JComposition *composition)
  :_composition(composition),
   _track(0),
   _part(0),
   _phrase(0),
   _voice(0)
{

}

// JFocus *
// JFocus::the()
// { 
//   if (_the == 0) _the=new JFocus();
//   return _the;
// }

void 
JFocus::touchState()
{
  //  if (_event !=0) {
//   if (_phrase != 0) {
//     JPhraseController *cntrl   = _phrase->controller();
//     const JGesture    *gesture = cntrl->focus();
//     if (geture != 0) {
//       _cursor->setBeat(gesture->left());
// //       const JEffectNode *effect=event->seekEffect(NOTE_EFFECT);
// //       if (effect != 0)
// // 	_cursor->setPitch(effect->index());
//     }
//   }
  notifyObservers(this);
}

void
JFocus::setTrack(JTrack *track,bool quiet)
{

  if (track != _track) _part=0;

  _track=track;

  if (_track == 0) {
    _part = 0;
    _phrase = 0;

  } else {

    if ( _part == 0 ) {

      _part=nextPart(true);

      //      if ( _part != 0 ) {
	_phrase = nextPhrase(true);
	// }
      
      if (_track->player() != 0) {
	if (_track->player()->voice() != 0) {
	  _voice=_track->player()->voice();
	}
      }
    }
  }

  if (!quiet) touchState();
}


JTrack *
JFocus::track() const
{
  return _track;
}




// JTrack *
// JFocus::nextTrack(bool quiet)
// {
//   if (_track == 0) { 
//     _track=_composition->trackList()->first();
//   } else {
//     _track=(JTrack *)_composition->trackList()->itemAfter(_track);
//   }
//   _part=0;
//   nextPart(true);
//   assert(_track != 0);
//   if (_track->player() != 0) {
//     if (_track->player()->voice() != 0) {
//       _voice=_track->player()->voice();
//     }
//   }
//   if (!quiet) touchState();
//   return _track;
// }


// JTrack * 
// JFocus::prevTrack(bool quiet)
// {
//   if (_track == 0) { 
//     _track=_composition->trackList()->last();
//   } else {
//     _track=(JTrack *)_composition->trackList()->itemBefore(_track);
//   }
//   _part=0;
//   _phrase=0;

//   nextPart(true);
//   assert(_track != 0);

//   if (_track->player() != 0) {
//     if (_track->player()->voice() != 0) {
//       _voice=_track->player()->voice();
//     }
//   }

//   if (!quiet) touchState();
//   return _track;
// }


JVoice * 
JFocus::voice()  const 
{ 
  return _voice; 
}


void
JFocus::setPart( JPart *part,bool quiet)
{
  if (_part == part) return;
  _part=part;
  _phrase=0;
  _phrase=nextPhrase(true);
  if (!quiet) touchState();
}



JPart *
JFocus::part() const 
{
  return _part;
}




JPart *
JFocus::nextPart(bool quiet)
{

  if (_track == 0) {
    return 0;
  }

  if (_part == 0) { 
    _part=_composition->partList()->first();
  } else {
    _part=(JPart *)_composition->partList()->itemAfter(_part);
  }


  _phrase=0;

  if (_part != 0)  {
    nextPhrase(true);
  }

  if (!quiet) touchState();
  return _part;
}


JPart * 
JFocus::prevPart(bool quiet)
{

  if (_track == 0) {
    return 0;
  }

  
  //  JPartListTrack *ptrack=_track->partListTrack();

  if (_part == 0) { 
    _part=_composition->partList()->last();
  } else {
    _part=(JPart *)_composition->partList()->itemBefore(_part);
  }

  _phrase=0;
  nextPhrase(true);
  if (!quiet) touchState();
  return _part;
}





JPhrase *
JFocus::phrase() const
{
  return _phrase;
}



void
JFocus::setPhrase( JPhrase *phrase,bool quiet)
{
  if ( _phrase == phrase ) return;
  _phrase=phrase;
  if (!quiet) touchState();
}






JPhrase *
JFocus::nextPhrase(bool quiet)
{
  if (_track == 0) {
    return 0;
  }
  

  if (_phrase == 0) { 
    _phrase=_track->phraseList()->first();
  } else {
    _phrase=(JPhrase *)_track->phraseList()->itemAfter(_phrase);
  }

  if (!quiet) touchState();

  return _phrase;
}


JPhrase * 
JFocus::prevPhrase(bool quiet)
{


  if (_track == 0) {
    return 0;
  }

  if (_phrase == 0) { 
    _phrase=(JPhrase *)_track->phraseList()->last();
  } else {
    _phrase=(JPhrase *)_track->phraseList()->itemBefore(_phrase);
  }

  if (!quiet) touchState();

  return _phrase;

}






//  JEvent *
// JFocus::event() const
// {

// //   if (_event==0) {
// //     _event=nextEvent(true);
// //     if (!quiet) touchState();
// //   }
  
//   return _event;
// }



// void
// JFocus::setEvent(const JEvent *event,bool quiet)
// {
//   //  if ( _event == event ) return;
//   _event=(JEvent *)event;
//   if (!quiet) touchState();
// }






// JEvent *
// JFocus::nextEvent(bool quiet)
// {

//   if (_event == 0)  return 0;

//   if (_event->isTail()) return _event;

//   _event=_event->next();

//   if (!quiet) touchState();

//   return _event;
// }


// JEvent * 
// JFocus::prevEvent(bool quiet)
// {

//   if (_event == 0)  return 0;

//   if (_event->isHead()) return _event;

//   _event=_event->prev();

//   if (!quiet) touchState();

//   return _event;
// }
















