#ifndef _JEffectEventGesture_H
#define _JEffectEventGesture_H

#include "JGesture.h"
#include "rep/JMidiOutEvent.h"

class JEffectEventGesture : public JGesture
{

public:
  JEffectEventGesture(JBeat on,JMidiOutEvent);
  JGesture *     clone() const;
  JNotator *     createNotator(JScorePainter *) const;
  JSequencer *   createSequencer(JPlayer *) const;
  bool           write(ostream &) const;
  bool           read(JReader &);
  JBeat          end() const { return _start; }
  JMidiOutEvent  event() const { return _event; }
  const char *   typeName() const { return "$Effect"; }
  JDuration      duration() const { return JDuration(0); }
private:
  JMidiOutEvent  _event;
};


#endif

